<?php
header("Content-Type: text/html; charset=utf-8");
set_time_limit(0);
$SLASH=PHP_OS=="Linux"?'/':'\\';
$ThisScript=pathinfo($_SERVER['PHP_SELF'],PATHINFO_BASENAME);
$EUROASM_HOME=strtr(substr($_SERVER['SCRIPT_FILENAME'],0,-1-strlen($ThisScript)),"/",$SLASH);
$IdSearch=array('$','?','@','%','#','='); $IdReplace=array('do','qm','at','pc','ha'.'eq');
$SM=GetSitemap($EUROASM_HOME.$SLASH."sitemap.ini"); // Load files information.
$SubdirList=array(); // All subdirectories declared in "sitemap.ini".
foreach ($SM as $site) if (!in_array($site['Subdir'],$SubdirList) &&
  file_exists($EUROASM_HOME.$SLASH.$site['Subdir'].$SLASH))  $SubdirList[]=$site['Subdir'];
$EXTW=isset($_REQUEST['EXTW']);
$Version=GetVersion();$TimeStamp=GetTimeStamp($Version);
$WhatsNew=@trim($_REQUEST['WhatsNew']);
//************************************************************************************
if (isset($_REQUEST['LstView']))
{$SourceDir=$EUROASM_HOME.$SLASH."easource";
$LstFile=$SourceDir.$SLASH."euroasm.htm.lst";
$Headline=file_exists($LstFile)?"<h2>Euroasm $Version build listing <q>$LstFile</q></h2>":
"<del>Euroasm listing <q>$LstFile</q> was not found.</del>";
chdir($SourceDir);
echo "<!doctype html><html lang='en'><head>
<meta http-equiv='Content-Type' content='text/html; charset=utf-8'/>
<meta name='viewport' content='width=device-width, initial-scale=1.0, maximum-scale=2.0, user-scalable=yes'>
<link rel='stylesheet' href='./euroasm.css' type='text/css'/>
<link rel='shortcut icon' href='./favicon.ico'/>
<title>Listing file euroasm.htm.lst</title>
</head>
<body class='EAHOME' id='top'>
$Headline
<samp>";if (file_exists($LstFile)) echo file_get_contents($LstFile);
echo "\r\n</samp></body></html>";exit();
} // endif LstView
//************************************************************************************
echo "<!doctype html><html lang='en'><head>
<meta http-equiv='Content-Type' content='text/html; charset=utf-8'/>
<meta name='viewport' content='width=device-width, initial-scale=1.0, maximum-scale=2.0, user-scalable=yes'>
<meta name='description' content='&euro;ASM generator'/>
<meta name='author' content='Pavel vitsoft Šrubař'/>
<link rel='stylesheet' href='./euroasm.css' type='text/css'/>
<link rel='shortcut icon' href='./favicon.ico'/>
<title>Generate HTML</title>
</head>
<body class='EAHOME' id='top' onload='document.getElementById(\"Wait\").style.display=\"none\";'>
<img id='Wait' src='./objlib/wait.gif' alt='Please wait...' title='Please wait...'/>
<div class='HEADMENU'><table>
<tr><td rowspan='2' title='&euro;ASM - assembler and linker'><img src='./favicon.ico' alt='EuroAssembler'/>
<td><a href='./index.htm' title='Alphabetical index of all &euro;ASM elements, directives and instructions'>Index</a></td>
<td><a href='./eadoc/' class='EADOC' title='Documentation of EuroAssembler'>Manual</a></td>
<td><a href='http://euroassembler.eu/download/' title='History &amp; download of the latest and previous versions'>Download</a></td>
<td><a href='./easource/' class='EASOURCE' title='Source files of EuroAssembler itself'>Source</a></td>
<td><a href='./maclib/' class='MACLIB' title='Macro libraries shipped with &euro;ASM'>Macros</a></td>
<td rowspan='2' title='Find the searched token in any text file on this site'>
<form method='post' action='./search.php' enctype='multipart/form-data' accept-charset='utf-8'>
<input type='text' id='q' placeholder='Searched word(s)' name='q' value=''/>
<br/><label title='Check the box to find the expression even if it is surrounded by other letters | digits.'>
<input type='checkbox' name='EW'/><small>Embedded word</small></label>
<br/><label title='Check the box for case-insensitive search.'>
<input type='checkbox' name='CI'/><small>Case ins.</small></label>
<input type='submit' title='Search for the specified word|expression in all site files.' name='find' value='Search'/>
</form></td></tr><tr>
<td><a href='./sitemap.htm' title='List of directories and files on this site'>Sitemap</a></td>
<td><a href='./eadoc/links.htm' class='EADOC' title='References and external links to resources used in EuroAssembler developement'>Links</a></td>
<td><a href='http://euroassembler.eu/forum/' title='Discussion forum concerning EuroAssembler'>Forum</a></td>
<td><a href='./eatests/' class='EATESTS' title='Program snippets for testing the function of &euro;ASM'>Tests</a></td>
<td><a href='./objlib/' class='OBJLIB' title='Skeletons and sample objects and projects shipped with &euro;ASM'>Projects</a></td>
</tr></table></div>
<h1>generate.php
<br/><a href='#Build'>Build</a>
<br/><a href='#EasmCrib'>Crib</a>
<br/><a href='#UpdateXref'>Cross references</a>
<br/><a href='#UpdateLinks'>External links</a>
<br/><a href='#UpdateHeads'>HTML heads</a>
<br/><a href='#UpdateTails'>HTML tails</a>
<br/><a href='#UpdateEuroasmIndex'>Index</a>
<br/><a href='#LinkCheck'>Link check</a>
<br/><a href='#Release'>Release</a>
<br/><a href='#Replace'>Search &amp; replace</a>
<br/><a href='#UpdateSiteMaps'>Site maps</a>
<br/><a href='#TestAll'>Test all</a>
<br/><a href='#UpdateTestIndex'>Test index</a>
</h1><p>Script <strong>generate.php</strong> provides bulk update and generating
of &euro;ASM HTML files.</p>
<p>It is intended to be used by EuroAssembler developers rather than by ordinary users (programmers).
It should be placed in the developer's local &euro;ASM website root, never on the public <a class='EXTW'
href='https://euroassembler.eu'>EuroAssembler.eu</a> site.</p>
<p>Original version of each file affected by this script is saved as <q>*.*.0.prev</q>.
Up to ten previous versions of each updated file is
backed up with the original file name appended by extension <q>.?.prev</q>,
where <code>?</code> is the generation number 0..9.</p>
<br class='CLEAR'/><hr/>";

//*****************************************************************************************Search & replace
echo "<h1 id='Replace'><a href='#top'>&uarr; Search &amp; replace</a></h1>
<p>Search the selected directories and files for a specified expression
and replace it with another one.<br/>
The expressions may contain space(s) and any non-white character, including punctuation and UTF-8.</p><br class='CLEAR'/>";
mb_internal_encoding('UTF-8');
$s=@$_REQUEST['s'];
$sLen=mb_strlen($s);
$sSafe=htmlspecialchars($s);
$r=@$_REQUEST['r'];
$rLen=mb_strlen($r);
$rSafe=htmlspecialchars($r);
$SearchableTypes=array(
".asm",
".bat",
".cmd",
".css",
".htm",
".html",
".inc",
".ini",
".mac",
".php",
".sh",
".txt",
);
$SelectedTypes=array();
foreach ($SearchableTypes as $type)
 {$typ=substr($type,1);
  ${"checkedT$typ"}="";
  if (isset($_REQUEST["T$typ"])) {$SelectedTypes[]=$type;${"checkedT$typ"}=" checked";}
 } // endforeach $type
$SearchableDirs=array($EUROASM_HOME);
$SelectedDirs=array();$checkedD="";
if (isset($_REQUEST['D'])) {$SelectedDirs[]=$EUROASM_HOME;$checkedD=" checked";} // Euroasm home dir.
$Objects=scandir($EUROASM_HOME);
foreach ($Objects as $object)
{if ($object=='.' || $object=='..') continue;
 if (!is_dir($object)) continue;
 $SearchableDirs[]=$EUROASM_HOME.$SLASH.$object;
 ${"checkedD$object"}="";
 if (isset($_REQUEST["D$object"])) {$SelectedDirs[]=$EUROASM_HOME.$SLASH.$object;${"checkedD$object"}=" checked";}
} // endforeach $object
if (isset($_REQUEST['Replace']))
{echo "<pre>"; $Total=0;
 $Letters=" abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_@`\$";
 if ($sLen<3) {$SelectedDirs=array();echo "<del>Searched expression must have at least 3 characters.</del>";}
 foreach ($SelectedDirs as $dir)
 {$FileList=scandir($dir);
  foreach ($FileList as $file)
  {if (!in_array(strtolower(substr($file,-4)),$SelectedTypes)) continue;
   $NewFileName=$dir.$SLASH.$file;
   $OldFileName=ShiftGenerations($NewFileName);
   echo "Updating file &quot;$NewFileName&quot; ... ";
   if (!$OldFileData=file_get_contents($OldFileName)) {echo "<del>error reading $OldFileName</del>\r\n";continue;}
   $NewFileData="";
   $times=0;$iPos=$sPos=$iPos=$cPos=$rPos=0;
   $OldFileLen=mb_strlen($OldFileData);
   while (($sNewPos=@mb_strpos($OldFileData,$s,$iPos))!==false)
   {if (!isset($_REQUEST['NWW'])) // If Whole Words only.
    {$prevChar=0; if ($sNewPos>0) $prevChar=mb_substr($OldFileData,$sNewPos-1,1);
     if (strlen($prevChar)>1 || strpos($Letters,$prevChar)) {$sPos=$sNewPos+1; continue;} // If previous char is a letter.
     $nextChar=0; if (($sNewPos+$sLen)<$OldFileLen) $nextChar=mb_substr($OldFileData,$sNewPos+$sLen,1);
     if (strlen($nextChar)>1 || strpos($Letters,$nextChar)) {$iPos=$sNewPos+1; continue;} // If following char is a letter.
    } // endif NWW not checked.
    $times++;$Total++;
    $len=$sNewPos-$cPos;
    $NewFileData .= mb_substr($OldFileData,$sPos,$len);
    $NewFileData .= $r;
    $cPos+=$len+$sLen;
    $rPos+=$len+$rLen;
    $sPos=$iPos=$sNewPos+$sLen;
   } // endWhile search found.
   $NewFileData.=mb_substr($OldFileData,$cPos);
   if (!file_put_contents($NewFileName,$NewFileData)){echo "<del>error writing $NewFileName</del>\r\n";continue;}
   if (!$times) echo "<span class='DIMMED'>replaced 0 times.</span>\r\n";
   else echo "replaced <b>$times</b> times.\r\n";
   flush();@ob_flush();
  }// endforeach $file
 } // endforeach $subdir
 echo "</pre>\r\n<p>Expression &quot;<ins>$sSafe</ins>&quot; was found
and replaced with &quot;<ins>$rSafe</ins>&quot; <b>$Total</b> times.</p>";
echo "<p>Search &amp; replace finished.</p>"; flush();@ob_flush();sleep(1);
} // endif Replace pressed.
echo "<form action='#Replace' method='post' enctype='multipart/form-data' accept-charset='utf-8'>\r\n";
echo "<div class='FLOATING'><table><tr><th>Searched directory</th><th>Select</th></tr>\r\n";
foreach ($SearchableDirs as $dir  )
{$subdir=substr($dir,strlen($EUROASM_HOME)+1);
 $displaydir=str_replace("\\","/",$dir.$SLASH);   // &#x29F5; is too big.
 echo "<tr><td>$displaydir</td><td><input type='checkbox' name='D$subdir'".${"checkedD$subdir"}."/></td></tr>\r\n";
} // endforeach $dir
echo "</table></div>\r\n<div class='FLOATING'><table><tr><th>File type</th><th>Select</th></tr>\r\n";
foreach ($SearchableTypes as $type)
{$typ=substr($type,1); // Remove leading point.
 echo "<tr><td>*$type</td><td><input type='checkbox' name='T$typ'".${"checkedT$typ"}."/></td></tr>\r\n";
} // endforeach $type
echo "</table></div><br class='CLEAR'/>
<table><tr><th>Searched expression</th><td>
<input type='text' id='s' size='32' placeholder='Original expression' name='s' value='$sSafe'/></td></tr>
<tr><th>Replace with</th><td>
<input type='text' id='r' size='32' placeholder='New expression' name='r' value='$rSafe'/></td?</tr>
<tr><td><small>Replace even when the searched expression is not a distinct whole word
<br/>(it is surrounded by other letters or digits)</small></td>
<td><input type='checkbox' name='NWW'/><small>Embedded word</small></td></tr>
</table>
<input type='submit' name='Replace' value='Search &amp; replace'/>
</form><br class='CLEAR'/><hr/>";
//**********************************************************************Crib
$CribFile=$EUROASM_HOME.$SLASH."eadoc".$SLASH."euroasm.png";
echo "<h1 id='EasmCrib'><a href='#top'>&uarr; &euro;ASM crib</a></h1>
<p>Generate <em>cheat sheet</em> with clearly organized most important
information tables concerning EuroAssembler language.
The sheet is a PNG image (2480px &times; 3508px),
printable to paper A4 (210mm &times; 297mm).</p>
<p>Its contents is defined here in <code>$ThisScript.GenerateCrib()</code>
and it is stored to file <a class='EXTW' target='_blank'
href='./eadoc/euroasm.png'>eadoc/euroasm.png</a>.</p>";
if (isset($_REQUEST['GenerateCrib']))
{echo "<pre>";
$CribOK=GenerateCrib($CribFile);
echo "</pre>";
if ($CribOK) echo "EuroAssembler sheet <a class='EXTW' target='_blank'
href='./eadoc/euroasm.png'>eadoc/euroasm.png</a> was generated.";
else echo "<del><q>euroasm.png</q> could not be generated.</del>";
} // endif GenerateCrib pressed.
echo "\r\n<form action='#EasmCrib' method='post'>
<input type='submit' name='GenerateCrib' value='Generate &euro;ASM sheet'/></form>
<br class='CLEAR'/><hr/>\r\n";
//**********************************************************************HTML heads
echo "<h1 id='UpdateHeads'><a href='#top'>&uarr; HTML heads</a></h1>
<p>Generate HTML division <code>&lt;head&gt;</code> plus the main menu strip in the beginning
of HTML division <code>&lt;body&gt;</code> in all <q>*.htm</q> files.</p>
<table><tr><th>Updated files</th><th>Begin marker</th><th>End marker</th></tr>
<tr><td><a class='EXT' href='./sitemap.htm'>*.htm</a></td>
<td><em>Start of file</em></td><td><code>&lt;--/HEADMENU--&gt;</code></td></tr>
</table><p>HTML heads should be updated whenever HEADMENU was changed in
<code>$ThisScript.GenHeader()</code> or when a new release is prepared.</p>";
if (isset($_REQUEST['UpdateHeads']))
{echo "<pre>";
foreach ($SubdirList as $subdir)
{$FILES=scandir($EUROASM_HOME.$SLASH.$subdir);
foreach ($FILES as $file)
{$Redirect=($file=="index.htm"&&substr($subdir,0,3)=="pro")?
"\r\n<meta http-equiv='refresh' content='1;url=../objlib/'/>":"";
 if (strtolower(substr($file,-4))==".htm")
    UpdateHtmlHead($EUROASM_HOME,$SLASH,$subdir,$file,$SM,$Version,$Redirect);
}} sleep(1);
echo "</pre><p>Update HTML heads finished.
Version=$Version, TimeStamp=$TimeStamp.</p>";
} // endif UpdateHeaders pressed.
echo "<form action='#UpdateHeads' method='post'>
Nominal version:<input type='text' size='8' name='Version' value='$Version'/>
<input type='submit' name='UpdateHeads' value='Update HTML heads'/></form>
<hr/>"; // ****************************************************************************HTML tails
echo "<h1 id='UpdateTails'><a href='#top'>&uarr; HTML tails</a></h1>
<p>Generate link <code>&#x25B2;Back to the top&#x25B2;</code> at the bottom of each page
for return to the top.
Then close divisions <code>&lt;/body&gt;</code> and <code>&lt;/html&gt;</code>
in all <q>*.htm</q> files.</p>
<table><tr><th>Updated files</th><th>Begin marker</th><th>End marker</th></tr>
<tr><td><a class='EXT' href='./sitemap.htm'>*.htm</a></td>
<td><code>&lt;--TAILMENU--&gt;</code></td><td><em>end of file</em></td></tr>
</table><p>HTML tails should be updated whenever TAILMENU was changed in
<code>$ThisScript.\$NewTail</code>.</p>";
if (isset($_REQUEST['UpdateTails']))
{$NewTail="<br class='CLEAR'/><a id='bottom' href='#top'>&#x25B2;Back to the top&#x25B2;</a>
</body></html>";
echo "<pre>";
foreach ($SubdirList as $subdir)
{$FILES=scandir($EUROASM_HOME.$SLASH.$subdir);
foreach ($FILES as $file)
 if (strtolower(substr($file,-4))==".htm")
 {if ($subdir) if (substr($subdir,-1)<>$SLASH) $subdir.=$SLASH;
  $filepath=$EUROASM_HOME.$SLASH.$subdir.$file;
  UpdateTail($filepath,$NewTail); flush();@ob_flush();
 }
} sleep(1);
echo "</pre><p>Update HTML tails finished.</p>";
} // endif UpdateTails pressed.
echo "<form action='#UpdateTails' method='post'><input type='submit' name='UpdateTails' value='Update HTML tails'/></form>
<br class='CLEAR'/><hr/>";
//************************************************************************************Site maps
echo "<h1 id='UpdateSiteMaps'><a href='#top'>&uarr; Site maps</a></h1>
<p>Generate table of directories and files declared in
<a href='sitemap.ini'>sitemap.ini</a> and insert the table between markers in following files:</p>
<table><tr><th>Updated files</th><th>Begin marker</th><th>End marker</th></tr>
<tr><td><code><a class='EXT' href='./sitemap.htm'>/sitemap.htm</a></code></td><td><code>&lt;!--SITEMAP--&gt;</code></td><td><code>&lt;!--/SITEMAP--&gt;</code></td></tr>
<tr><td><code><a class='EXT' href='./easource/ii.htm'>/easource/ii.htm</a></code></td><td><code>&lt;!--SRC_II--&gt;</code></td><td><code>&lt;!--/SRC_II--&gt;</code></td></tr>
<tr><td><code><a class='EXT' href='./easource/pf.htm'>/easource/pf.htm</a></code></td><td><code>&lt;!--SRC_PF--&gt;</code></td><td><code>&lt;!--/SRC_PF--&gt;</code></td></tr>
<tr><td><code><a class='EXT' href='./easource/index.htm'>/easource/index.htm</a></code></td><td><code>&lt;!--SRC_ALL--&gt;</code></td><td><code>&lt;!--/SRC_ALL--&gt;</code></td></tr>
<tr><td><code><a class='EXT' href='./maclib/index.htm'>/maclib/index.htm</a></code></td><td><code>&lt;!--MACLIB--&gt;</code></td><td><code>&lt;!--/MACLIB--&gt;</code></td></tr>
<tr><td><code><a class='EXT' href='./objlib/index.htm'>/objlib/index.htm</a></code></td><td><code>&lt;!--OBJLIB--&gt;</code></td><td><code>&lt;!--/OBJLIB--&gt;</code></td></tr>
</table>
<p>Files should be updated whenever a new file was created and <q>sitemap.ini</q> changed.</p>\r\n";
 if (isset($_REQUEST['UpdateSiteMaps']))
{$SITEMAP="<table><caption>Directory tree of EuroAssembler site</caption>
<tr><td class='TREE'><pre>
                euroasm&#x2512;                             &nbsp;
                       &#x2523;&#x2500;<span class='DIMMED'>download</span>
                       &#x2523;&#x2500;eadoc
                       &#x2523;&#x2500;easource
                       &#x2523;&#x2500;eatests
                       &#x2523;&#x2500;<span class='DIMMED'>forum</span>
                       &#x2523;&#x2500;maclib
                       &#x2523;&#x2500;objlib
                       &#x2523;&#x2500;probin
                       &#x2523;&#x2500;prodos16
                       &#x2523;&#x2500;prolin32
                       &#x2523;&#x2500;prolin64
                       &#x2523;&#x2500;prowin32
                       &#x2523;&#x2500;prowin64
                       &#x2523;&#x2500;eurotool
                       &#x2517;&#x2500;<span class='DIMMED'>version</span>
</pre></td></tr></table>
<table><caption>EuroAssembler site map</caption>
";
$SRC_II="<table><caption>Machine instruction modules</caption>
<tr><th colspan='2'>Instruction category</th><th>Uses registers</th><th>Module file</th></tr>\r\n";
$SRC_PF="<table><caption>Program formats modules</caption>
<tr><th>Format</th><th>Platform</th><th>Module file</th></tr>\r\n";
$SRC_GEN="<table><caption>General object modules</caption>
<tr><th>Class</th><th>Representation</th><th>Module file</th></tr>\r\n";
$SRC_MAC="<table><caption>Includable libraries used in &euro;ASM sources</caption>
<tr><th>Realm</th><th>OS</th><th>Support</th><th>Maclib file</th></tr>\r\n";
$SRC_ALL="\r\n";
$MACLIB="<table><caption>Includable libraries shipped with EuroAssembler</caption>
<tr><th>Realm</th><th>OS</th><th>Width</th><th>Contents</th><th>Maclib file</th></tr>\r\n";
$OBJLIB="<table><caption>Sample linkable files and projects</caption>\r\n";
foreach ($SM as $SITE=>$SA)
{$PseudoClass=$SA['PseudoClass']?" class='DIMMED'":"";
$tx=$SA['Tx'];$tag=$SA['Tag'];$File=$SA['File'];$Subdir=$SA['Subdir'];
$SITEMAP.="<tr><$tx>".$SA['Anchor']."</$tx><$tx>".$SA['Description']."</$tx></tr>\r\n";
if ($SA['IiCategory'])
$SRC_II.="<tr><th$PseudoClass>".$SA['IiCategory']."</th><td><small>".$SA['Representation']."</small></td>
<td><code>".$SA['Registers']."</code></td><td><code><a class='EXT' href='../easource/$File'>$File</a></code></td></tr>\r\n";
if ($SA['Pformat'])
$SRC_PF.="<tr><th$PseudoClass>".$SA['Pformat']."</th><td><small>".$SA['Representation'].
    "</small></td><td><a class='EXT' href='../easource/$File'>$File</a></td></tr>\r\n";
if ($SA['SourceName'] && !$SA['IiCategory'] && !$SA['Pformat'])
$SRC_GEN.="<tr><th$PseudoClass>".$SA['EaClass']."</th><td><small>".$SA['Representation'].
    "</small></td><td><a class='EXT' href='../easource/$File'>$File</a></td></tr>\r\n";
if (@$SA['EaSource']=="Yes")
$SRC_MAC.="<tr><th$PseudoClass>".$SA['Realm']."</th><td>".$SA['OS']."</td><td><small>".$SA['Description'].
    "</small></td><td><a class='EXT' href='../maclib/$File'>$File</a></td></tr>\r\n";
if ($Subdir=="maclib" && $SA['Realm'])
$MACLIB.="<tr><td>".@$SA['Realm']."</td><td>".@$SA['OS']."</td><td>".$SA['Width']."</td><td>".$SA['Description'].
"</td><td><a class='EXT' href='../maclib/$File'>$File</a></td></tr>\r\n";
foreach (array('objlib','probin','prodos16','prowin32','prowin64','prolin32','prolin64','eurotool') as $projdir)
if ($Subdir==$projdir)
if ($File && $File<>'index.htm')
$OBJLIB.="<tr><td>$Subdir/</td><td><a class='EXT' href='../$Subdir/$File'>$File</a></td>
<td>".$SA['Description']."</td></tr>\r\n";
else if ($File<>'index.htm') $OBJLIB.="<tr><th>$Subdir</th><th colspan='2'>".$SA['Description']."</th></tr>\r\n";
} //$SITE
$SITEMAP.="</table>\r\n";
$SRC_II.="</table>\r\n";
$SRC_PF.="</table>\r\n";
$SRC_GEN.="</table>\r\n";
$SRC_MAC.="</table>\r\n";
$MACLIB.="</table>\r\n";
$OBJLIB.="</table>\r\n";
echo "<pre>";
$SRC_ALL="<br class='CLEAR'/><div class='FLOATING'>
$SRC_GEN$SRC_II<br class='CLEAR'/>
$SRC_PF$SRC_MAC</div><br class='CLEAR'/>\r\n";
Update($EUROASM_HOME.$SLASH."sitemap.htm",$SITEMAP,"SITEMAP");
Update($EUROASM_HOME.$SLASH."easource".$SLASH."ii.htm",$SRC_II,"SRC_II");
Update($EUROASM_HOME.$SLASH."easource".$SLASH."pf.htm",$SRC_PF,"SRC_PF");
Update($EUROASM_HOME.$SLASH."easource".$SLASH."index.htm",$SRC_ALL,"SRC_ALL");
Update($EUROASM_HOME.$SLASH."maclib".$SLASH."index.htm",$MACLIB,"MACLIB");
Update($EUROASM_HOME.$SLASH."objlib".$SLASH."index.htm",$OBJLIB,"OBJLIB");
flush();@ob_flush();sleep(1);
echo "</pre><p>Update site maps finished.</p>";
} // endif UpdateSiteMaps pressed.
echo "<form action='#UpdateSiteMaps' method='post'><input type='submit' name='UpdateSiteMaps'
value='Update site maps'/></form><br class='CLEAR'/><hr/>";



//************************************************************************************External links
echo "<h1 id='UpdateLinks'><a href='#top'>&uarr; External links</a></h1>
<p>Generate HTML contents of <a href='./eadoc/links.htm'>Links</a> page based on definitions in
<a href='links.ini'>links.ini</a> and insert the contents between markers in following file:</p>
<table><tr><th>Updated files</th><th>Begin marker</th><th>End marker</th></tr>
<tr><td><code><a class='EXT' href='./eadoc/links.htm'>/eadoc/links.htm</a></code></td><td><code>&lt;!--LINKS--&gt;</code></td><td><code>&lt;!--/LINKS--&gt;</code></td></tr>
</table>
<p>Web links should be updated when definitions in <q>links.ini</q> were manually changed.</p>\r\n";
 if (isset($_REQUEST['UpdateLinks']))
{echo "<pre>";
$BegMarker="LINKS";$EndMarker="/$BegMarker";
$LINKS="<!--Contents between markers ".strtr($BegMarker,'<>-','{}=')." and ".strtr($EndMarker,'<>-','{}=').
" was generated by \"".pathinfo($_SERVER['PHP_SELF'],PATHINFO_BASENAME)."\".-->\r\n";

$CATEGORIES=array();$LINKS=""; $LA=parse_ini_file("links.ini",true); // print_r($LA);
foreach ($LA['LinkCategories'] as $CatId=>$CatTitle)
 { $LINKS.="<h2><a href='#".urlencode($CatId)."'>$CatTitle &darr;</a></h2>\r\n";
   $CATEGORIES[$CatId]=$CatTitle;
 }

foreach ($LA['LinkCategories'] as $CatId=>$CatTitle)
{$LINKS.="<hr/>
<h2 id='".urlencode($CatId)."'><a href='#top'>&uarr; $CatTitle</a></h2>\r\n";

foreach ($LA as $link=>$PA)
{if ($link=="LinkCategories") continue;
if ($PA['Category']<>$CatId) continue;
 $LINKS.="<h3><a href='#".urlencode($link)."'>[$link] &darr;</a></h3>\r\n";
}
foreach ($LA as $link=>$PA)
{if ($link=='LinkCategories') continue;
 if ($PA['Category']<>$CatId) continue;
$LINKS.="<dl id='".urlencode($link)."'><dt><a href='#".urlencode($CatId)."'>&uarr; [$link]</a>: &nbsp; &nbsp; ".$PA['Title']."\r\n<dd>";
$LINKS.="<abbr>Category:</abbr> ".$CATEGORIES[$PA['Category']];
foreach (array('Platform','Description','Format','Producent','Version') as $prop)
if (isset($PA[$prop])) $LINKS.="\r\n<br/><abbr>$prop:</abbr> ".$PA[$prop];
if (isset($PA['URL'])) $LINKS.="\r\n<br/><abbr>URL</abbr> <a class='EXTW' href='".$PA['URL']."'>".$PA['URL']."</a>";
if (isset($PA["ErrataPos1"]))
{$LINKS.="\r\n<br/><abbr>Errata</abbr><blockquote>\r\n";  $e=1;
while (isset($PA["ErrataPos$e"]))
 {$Right=isset($PA["ErrataRight$e"])?" should be\r\n<br/><ins>".$PA["ErrataRight$e"]."</ins>":"";
$LINKS.="<p><b>$e.</b> ".$PA["ErrataPos$e"]."\r\n<br/><del>".@$PA["ErrataWrong$e"].
 "</del>$Right</p>\r\n"; $e++;
 } $LINKS.="</blockquote>\r\n";
}
$LINKS.="</dd></dl>\r\n";
} // endforeach $link
} // endforeach $CatId
Update($EUROASM_HOME.$SLASH."eadoc".$SLASH."links.htm",$LINKS,"LINKS");
echo "</pre>";
flush();@ob_flush();sleep(1);
echo "</pre><p>Update external links finished.</p>";
} // endif UpdateLinks pressed.
echo "<form action='#UpdateLinks' method='post'><input type='submit' name='UpdateLinks'
value='Update external links'/></form><br class='CLEAR'/><hr/>";


//*****************************************************************************************Test index
echo "<h1 id='UpdateTestIndex'><a href='#top'>&uarr; Test index</a></h1>
<p>Enumerate the list of &euro;ASM tests available in directory <q>eatests/</q>,
retrieve their category and title (short description).
Then insert the list between markers in test index file:</p>
<table><tr><th>Updated files</th><th>Begin marker</th><th>End marker</th></tr>
<tr><td><code><a class='EXT' href='./eatests/index.htm'>/eatests/index.htm</a></code></td>
<td><code>&lt;!--TEST_CATEGORY--&gt;</code></td><td><code>&lt;!--/TEST_CATEGORY--&gt;</code></td></tr>
<tr><td><code><a class='EXT' href='./eatests/index.htm'>/eatests/index.htm</a></code></td>
<td><code>&lt;!--TEST_LIST--&gt;</code></td><td><code>&lt;!--/TEST_LIST--&gt;</code></td></tr>
</table>
<p>The test index should be updated whenever some test description changed
or when a new test was created | renamed | deleted.</p>\r\n";
if (isset($_REQUEST['UpdateTestIndex']))
{echo "<pre>\r\n";
// Static definition of test category names.
// Category applies on tests in the range of its key up to the next key.
$GA=array();
$GA[0]="Blocks";
$GA[1300]="Strings";
$GA[1400]="Numbers";
$GA[1600]="Symbols";
$GA[1640]="Symbol_attributes";
$GA[1710]="Literal_symbols";
$GA[2000]="Pseudoinstructions";
$GA[3000]="Addressing_modes";
$GA[3040]="Machine_instructions";
$GA[7000]="OutputFile";
$GA[7200]="Macros";
$GA[7300]="Variables";
$GA[7900]="Realmode_segmentation";
$GA[8000]="Linking";
$GA[9999]="End_of_Test_list";
$TEST_CATEGORY="";
foreach ($GA as $group) $TEST_CATEGORY.="<br/><a href='#$group'>".strtr($group,'_',' ')."</a>\r\n";
Update($EUROASM_HOME.$SLASH."eatests".$SLASH."index.htm",$TEST_CATEGORY,"TEST_CATEGORY");
$TEST_LIST=""; $TNA=array(); $lastN=0;
$TNAS=scandir($EUROASM_HOME.$SLASH."eatests");
foreach ($TNAS as $f)
{if (strlen($f)<>9) continue;
 if (strtolower(substr($f,-4))<>".htm") continue;
 if (strtolower(substr($f,0,1))<>"t") continue;
 $TNA[]=strtolower(substr($f,0,5));
}sort($TNA);
foreach ($TNA as $test)
{$TL=file($EUROASM_HOME.$SLASH."eatests".$SLASH.$test.".htm"); $Title="</i>title missing</i>";
 foreach ($TL as $L)
  if (substr($L,0,8)=="<!--T-->") {$Title=trim(substr($L,8)); break;}
 $Group="<br/>"; $testN=(integer)(substr($test,1));
 if ($testN>=$lastN)
 {$Group="<br/></small><h3><a href='#top' id='".$GA[$lastN]."'>&uarr; ".
          strtr($GA[$lastN],'_',' ')."</a></h3><small>\r\n<br/>";
  foreach ($GA as $N => $name) if ($N>$lastN) {$lastN=$N;break;}
 } $TEST_LIST.="$Group<a class='EXT' href='$test.htm'>$test</a> $Title\r\n";
} //$test
Update($EUROASM_HOME.$SLASH."eatests".$SLASH."index.htm",$TEST_LIST,"TEST_LIST");
//echo "TEST_LIST=\r\n".htmlentities($TEST_LIST); exit();
flush();@ob_flush();sleep(1);
echo "</pre><p>Update test index finished.</p>";
} // endif UpdateTestIndex pressed.
echo "<form action='#UpdateTestIndex' method='post'><input type='submit' name='UpdateTestIndex'
value='Update test index'/></form><br class='CLEAR'/><hr/>";

//*****************************************************************************************Cross references
echo "<h1 id='UpdateXref'><a href='#top'>&uarr; Cross references</a></h1>
<p>Update hyperlinks in <b>Invokes, Invoked by, Tested by</b> data definitions
in the documentation header of each method (Procedure)
in all EuroAssembler source files.</p>
<p>Position of inserted links is identified by HTML tags <code>dl dt dd</code>
rather than by comment markers.</p>
<table><tr><th>Updated files</th><th>Begin marker</th><th>End marker</th></tr>
<tr><td><code><a class='EXT' href='./easource/index.htm'>/easource/*.htm</a></code></td>
<td><code>&lt;dl&gt;</code></td><td><code>&lt;/dl&gt;</code></td></tr>
</table>
<p>Cross references should be updated after major changes has been done
in EuroAssembler sources and tests. Regenerating cross references takes several minutes.</p>\r\n";
if (isset($_REQUEST['UpdateXref']))
{echo "<pre>\r\n";
echo "Reading &euro;ASM source files ...\r\n";flush();@ob_flush();
$modulAr=array();
foreach ($SM as $site) if ($site['SourceName']) $modulAr[]=$site['SourceName'];
$allProc=$InvokedBy=$Invokes=$TestedBy=array();
foreach ($modulAr as $modul)
{$SrcFileName=$EUROASM_HOME.$SLASH."easource".$SLASH.$modul.".htm";
 if (!file_exists($SrcFileName)) {echo "<del>$SrcFileName not found.</del>";continue;}
 $h=fopen($SrcFileName,'r'); $lineNr=0; $inProc="";
 while (!feof($h))
 {$lineNr++;$line=trim(fgets($h));
  $LA=Parse($line,$lineNr);
  switch ($LA['operation'])
  {case 'Procedure':case 'PROC':if (strpos($LA['label'],'.')!==false) break; // Ignore local proc.
    if ($inProc) die("<del>Expecting EndProcedure $inProc</del>".print_r($LA,1));
    $inProc=$LA['label']; $Invokes[$inProc][]=""; break;
   case 'EndProcedure':case 'ENDP':case 'ENDPROC':if (substr($LA['operand'],0,1)=='.') break; // Ignore local endp.
    if (!$inProc) die("<del>Missing $inProc Procedure</del>".print_r($LA,1));
    $inProc=""; break;
   case 'Invoke': case 'CALL': if(!$inProc) break;
    if (strpos($LA['operand'],'.')!==false) break;
    if (strpos($LA['operand'],'{')!==false) break;
    if (substr($LA['operand'],0,1)=='.') break;
    if (substr($LA['operand'],0,1)=='[') break;
    if (substr($LA['operand'],0,3)=='EAX') break;
    $Invokes[$inProc][]=$LA['operand'];
   default: break;
   } // endswitch operation
  } //endwhile feof
 fclose($h);
} // endforeach $modul

echo "Updating <b>Invokes</b> ...\r\n";flush();@ob_flush();
foreach ($Invokes as $proc=>$invoked)
  {sort($invoked);$Invokes[$proc]=array_filter(array_unique($invoked));}
foreach ($Invokes as $proc=>$invoked)
  {$allProc[]=$proc; foreach ($invoked as $proc) $allProc[]=$proc;
   sort($allProc); $AllProc=array_unique($allProc);}
echo "Updating <b>Invoked by</b>...\r\n";flush();@ob_flush();
foreach ($AllProc as $proc)
 {$InvokedBy[$proc]=array();
  foreach ($Invokes as $who=>$whomAr)
    foreach ($whomAr as $whom)
     if ($whom==$proc)  $InvokedBy[$whom][]=$who;
 } // endforeach $proc
echo "Reading &euro;ASM tests ...\r\n";flush();@ob_flush();
$TNAS=scandir($EUROASM_HOME.$SLASH."eatests"); $TNA=array();
foreach ($TNAS as $f)
{if (strlen($f)<>9) continue;
 if (strtolower(substr($f,-4))<>".htm") continue;
 if (strtolower(substr($f,0,1))<>"t") continue;
 $TNA[]=strtolower(substr($f,0,5));
} sort($TNA);
echo "Updating <b>Tested by</b> ...\r\n";flush();@ob_flush();
foreach ($TNA as $test)
{$testFA=file($EUROASM_HOME.$SLASH."eatests".$SLASH.$test.".htm");
 foreach ($testFA as $line)
 {$LA=explode('>',$line);if ($LA[0]<>'<!--P--') continue;
  $TestedBy[trim($LA[1])][]=$test;
 }
} // endforeach $test
foreach ($modulAr as $modul)
{$NewFileName=$EUROASM_HOME.$SLASH."easource".$SLASH.$modul.".htm";
$OldFileName=ShiftGenerations($NewFileName);
echo "Updating file \"$NewFileName\"\r\n";flush();@ob_flush();
$text=file_get_contents($OldFileName); $out=fopen($NewFileName,'w'); $beginPos=0;
while (($dlPos=strpos($text,'<dl id="',$beginPos))!==false)
{file_put_contents($NewFileName,substr($text,$beginPos,$dlPos-$beginPos),FILE_APPEND);
$idEnd=strpos($text,'"',$dlPos+8);
$id=substr($text,$dlPos+8,$idEnd-$dlPos-8);
$dlEnd=strpos($text,'</dl>',$idEnd);
$dl=substr($text,$dlPos,$dlEnd+5-$dlPos);
$beginPos=$dlEnd+5;
if (in_array($id,$AllProc))
{$DL=ParseDL($dl); sort($Invokes[$id]); $InvokesStr="";
foreach ($Invokes[$id] as $fn)
$InvokesStr.=FnLink($fn,$IdSearch,$IdReplace,$modul);
$DL['Invokes']=$InvokesStr; sort($InvokedBy[$id]); $InvokedByStr="";
foreach ($InvokedBy[$id] as $fn)
$InvokedByStr.=FnLink($fn,$IdSearch,$IdReplace,$modul); $DL['Invoked by']=$InvokedByStr; $TestedByStr="";
if (isset($TestedBy[$id]))
foreach ($TestedBy[$id] as $tst) $TestedByStr.=TstLink($tst);
$DL['Tested by']=$TestedByStr;
$dl=@UnparseDL($DL,$id,$DA);
} // endif inarray
file_put_contents($NewFileName,$dl,FILE_APPEND);
} // endwhile <dl>
file_put_contents($NewFileName,substr($text,$beginPos),FILE_APPEND);
} // endforeach $modul
echo "</pre><p>Update of cross references finished.</p>"; flush();@ob_flush();sleep(1);
} // endif UpdateXref pressed.
echo "<form action='#UpdateXref' method='post'><input type='submit' name='UpdateXref'
value='Update cross references'/></form><br class='CLEAR'/><hr/>";

//************************************************************************************Index
echo "<h1 id='UpdateEuroasmIndex'><a href='#top'>&uarr; EuroAssembler index</a></h1>
<p>Generate list of language terms, instructions, attributes,
built-in system variables etc., and insert alphabetically sorted links to the home index page.</p>
<table><tr><th>Updated files</th><th>Begin marker</th><th>End marker</th></tr>
<tr><td><code><a class='EXT' href='./index.htm'>/index.htm</a></code></td><td><code>&lt;!--INDEX--&gt;</code></td><td><code>&lt;!--/INDEX--&gt;</code></td></tr>
</table>
<p>Indexed links are created from the dictionary tables and from headlines in English manual.
Link anchor is parsed from <code>id='anchor'</code>, displayed title is parsed from
nearby <code>title='Displayed title'</code>.</p>
<table><tr><th>Style class</th><th>Indexed category</th><th>Information source</th></tr>
<tr><td>XAT</td><td><a class='XAT'>Attributes</a></td><td><a class='EXT' href='./easource/dict.htm#DictAttributes'>Dictionary&gt;Attributes</a></td></tr>
<tr><td>XKV</td><td><a class='XKV'>Keyword enumerated values</a></td><td><a class='EXT' href='./easource/dict.htm'>Dictionary&gt; <i>values</i></a></td></tr>
<tr><td>XKN</td><td><a class='XKN'>Keyword names</a></td><td><a class='EXT' href='./easource/dict.htm'>Dictionary&gt; <i>keys</i></a></td></tr>
<tr><td>XLG</td><td><a class='XLG'>Language elements</a></td><td><a class='EXT' href='./eadoc/index.htm'>Manual</a></td></tr>
<tr><td>XMI</td><td><a class='XMI'>Macroinstructions</a></td><td><a class='EXT' href='./maclib/index.htm'>Macrolibraries</a></td></tr>
<tr><td>XII</td><td><a class='XII'>Machine instructions</a></td><td><a class='EXT' href='./easource/ii.htm'>Ii?List of <q>ii?.htm</q></a></td></tr>
<tr><td>XPF</td><td><a class='XPF'>Machine prefixes</a></td><td><a class='EXT' href='./easource/dict.htm#DictPrefixes'>Dictionary&gt;Prefixes</a></td></tr>
<tr><td>XRG</td><td><a class='XRG'>Machine registers</a></td><td><a class='EXT' href='./easource/dict.htm#DictRegisters'>Dictionary&gt;Registers</a></td></tr>
<tr><td>XOP</td><td><a class='XOP'>Operators</a></td><td><a class='EXT' href='./easource/dict.htm#DictOperators'>Dictionary&gt;Operators</a></td></tr>
<tr><td>XPI</td><td><a class='XPI'>Pseudoinstructions</a></td><td><a class='EXT' href='./eadoc/index.htm#PseudoInstructions'>Manual&gt;Pseudoinstructions</a></td></tr>
<tr><td>XSV</td><td><a class='XSV'>System %^variables</a></td><td>
<a class='EXT' href='./easource/eaopt.htm#EaoptEasmList'>%EaopEasmList</a>
<a class='EXT' href='./easource/eaopt.htm#EaoptFeaList'>%EaopFeaList</a>
<a class='EXT' href='./easource/eaopt.htm#EaoptMiscList'>%EaopMiscList</a>
<a class='EXT' href='./easource/eaopt.htm#EaoptStatusList'>%EaopStatusList</a>
<a class='EXT' href='./easource/pgmopt.htm#PgmoptList'>%PgmoptList</a></td></tr>
</table>
<p>The alphabetical index should be re-created whenever EuroAssembler language, manual, or some
macro library was updated. Reindexing takes several minutes.</p>\r\n";
if (isset($_REQUEST['UpdateEuroasmIndex']))
{echo "<pre>";
$dict=  $EUROASM_HOME.$SLASH."easource".$SLASH."dict.htm";
$eaopt= $EUROASM_HOME.$SLASH."easource".$SLASH."eaopt.htm";
$pf=    $EUROASM_HOME.$SLASH."easource".$SLASH."pf.htm";
$pgmopt=$EUROASM_HOME.$SLASH."easource".$SLASH."pgmopt.htm";
$sss=   $EUROASM_HOME.$SLASH."easource".$SLASH."sss.htm";
$X=array_merge(
IndexDict($dict,  "DictAttributes::",       "XAT","attr.operator","Attributes"),
IndexDict($dict,  "DictIiMfx::",            "XKN","instr.modifier","InstructionModifiers"),
IndexDict($dict,  "DictDynLinkKeys::",      "XKN","scope property","Scope"),
IndexDict($dict,  "DictForKeys::",          "XKN","%FOR param.","pcFOR"),
IndexList($eaopt, "%EaoptMiscList",         "XKN","EUROASM option","EUROASM"),
IndexList($eaopt, "%EaoptStatusList",       "XKN","EUROASM option","EUROASM"),
IndexList($eaopt, "%EaoptFeaList",          "XKN","Bool CPU feature","CPUfeatures"),
IndexDict($dict,  "DictIiMfg::",            "XKN","instr.modifier","InstructionModifiers"),
IndexList($pgmopt,"%PgmoptList",            "XKN","pgm.property","PROGRAM"),
IndexDict($dict,  "DictSegmentKeys::",      "XKN","segm.property","SEGMENT"),
IndexDict($dict,  "DictIiMfs::",            "XKN","instr.modifier","InstructionModifiers"),
IndexList($pf,    "%PfList",                "XKV","format","FORMATeq"),
IndexDict($dict,  "DictProgramModels::",    "XKV","model","MODELeq"),
IndexDict($dict,  "DictSegmentCombine::",   "XKV","segm.combine","SegmentCOMBINEeq"),
IndexDict($dict,  "DictSegmentPurpose::",   "XKV","segm.purpose","SegmentPURPOSEeq"),
IndexList($sss,   "%SssPurposeList",        "XKV","segm.purpose","SegmentPURPOSEeq"),
IndexDict($dict,  "DictIiMfPrefix::",       "XKV","instr.modifier","InstructionModifiers"),
IndexDict($dict,  "DictDisplayObj::",       "XKV","%DISPLAY param.","DisplayObj"),
IndexDict($dict,  "DictDatatypes::",        "XKV","datatype","DataTypes"),
IndexDict($dict,  "DictEaoptCpu::",         "XKV","CPU=","CPUeq"),
IndexDict($dict,  "DictEaoptSimd::",        "XKV","SIMD=","SIMDeq"),
IndexDict($dict,  "DictIiMfRound::",        "XKV","instr.modifier","InstructionModifiers"),
IndexDict($dict,  "DictIiMfMask::",         "XKV","instr.modifier","InstructionModifiers"),
IndexDict($dict,  "DictCodePages::",        "XKV","codepage","CODEPAGEeq"),
IndexDict($dict,  "DictBoolean::",          "XKV","Bool value","Enumerates"),
IndexDict($dict,  "DictFpConstants::",      "XOP","FP const.","FpSpecValues"),
IndexDict($dict,  "DictPrefixes::",         "XPF","prefix","Prefixes"),
IndexDict($dict,  "DictPseudo::",           "XPI","pseudoinstr.","PseudoInstructions"),
IndexDict($dict,  "DictRegisters::",        "XRG","register","Registers"),
IndexList($eaopt, "%EaoptFeaList",          "XSV","syst.variable","SystemVariablesEUROASM"),
IndexList($eaopt, "%EaoptEasmList",         "XSV","syst.variable","SystemVariablesEASM"),
IndexList($eaopt, "%EaoptMiscList",         "XSV","syst.variable","SystemVariablesEUROASM"),
IndexList($eaopt, "%EaoptStatusList",       "XSV","syst.variable","SystemVariablesEUROASM"),
IndexList($pgmopt,"%PgmoptList",            "XSV","syst.variable","SystemVariablesPROGRAM"),
IndexDict($dict,  "DictProgramSubsystems::","XKV","subsystem","SUBSYSTEMeq"),
IndexMaclib($EUROASM_HOME,$SLASH),
IndexII($EUROASM_HOME,$SLASH),
IndexManual($EUROASM_HOME.$SLASH."eadoc".$SLASH."index.htm"),
array());
echo "Sorting index aplhabetically ...\r\n";
uksort($X,"SortCaseInsensitive");
$INDEX="<span class='XLETTER'>";
for ($letter=ord('A');$letter<=ord('Z');$letter++)
    {$C=chr($letter); $INDEX.="\r\n<a href='#$C'>&darr;$C</a>";}
$INDEX.="\r\n</span><br class='CLEAR'/>\r\n".OneLetter($X,false);
for ($letter=ord('A');$letter<=ord('Z');$letter++) $INDEX.=OneLetter($X,chr($letter));
$INDEX.="\r\n<br class='CLEAR'/>";
Update($EUROASM_HOME.$SLASH."index.htm",$INDEX,"INDEX");
echo "</pre>\r\n<p>EuroAssembler <a class='EXT' href='index.htm'>index</a> was created with <b>".count($X)."</b> items.</p>"; flush();@ob_flush();sleep(1);
} // endif Update index pressed.
echo "<form action='#UpdateEuroasmIndex' method='post'>
<input type='submit' name='UpdateEuroasmIndex' value='Update &euro;ASM index'/>
</form><br class='CLEAR'/><hr/>";

//*****************************************************************************************Link check
echo "<h1 id='LinkCheck'><a href='#top'>&uarr; Link check</a></h1>
<p>Check if all anchors in all <q>*.htm</q> files link to a valid target file and anchor identifier.</p>\r\n";
 if (isset($_REQUEST['LinkCheck']))
{// In 1.pass find all id= identifiers in all HTML files.
echo "<pre>";
if ($EXTW) echo "External links will be checked, too.\r\n";
else echo "External links will not be checked.\r\n";
$Fragments=array();
foreach ($SubdirList as $subdir)
{$URLSLASH=$subdir?"/":"";
echo "<br/>Loading identifiers from <q>.$URLSLASH$subdir/*.htm</q> ...";
flush();@ob_flush();
$FileList=scandir($EUROASM_HOME.$SLASH.$subdir);
foreach ($FileList as $file)
{if (strtolower(substr($file,-4))==".htm" || strtolower(substr($file,-5))==".html")
{$FilePath=$subdir?$EUROASM_HOME.$SLASH.$subdir.$SLASH.$file:$EUROASM_HOME.$SLASH.$file;
$contents=file_get_contents($FilePath);
$idPos=$endPos=0;
while ($idPos=stripos($contents,"id=",$endPos))
{$endPos=$idPos+1;
$quote=substr($contents,$idPos+3,1); if ($quote<>"'"&&$quote<>'"') continue;
 if (!$endPos=strpos($contents,$quote,$idPos+4)) continue;
 $Fragments[$FilePath][]=str_replace($IdSearch,$IdReplace,substr($contents,$idPos+4,$endPos-$idPos-4));
} // endwhile
}
} // endForEach $file
} // endForEach $subdir
$Total=$Dead=0;
foreach ($SubdirList as $subdir)
{// In 2.pass find and check all href= references in all HTML files.
$URLSLASH=$subdir?"/":"";
$DIRSLASH=$subdir?$SLASH:"";
echo "<br/>Checking links from <q>.$URLSLASH$subdir/*.htm</q> ...";
$FileList=scandir($EUROASM_HOME.$SLASH.$subdir);
foreach ($FileList as $file)
if (strtolower(substr($file,-4))==".htm" || strtolower(substr($file,-5))==".html")
{$FilePath=$EUROASM_HOME.$SLASH.$subdir.$DIRSLASH.$file;
$contents=file_get_contents($FilePath);
$aPos=$gtPos=0;
while ($aPos=stripos($contents,"<a ",$gtPos))
{$gtPos=$aPos+1;flush();@ob_flush();
if (!$gtPos=strpos($contents,">",$aPos+2)) continue;
$anchor=substr($contents,$aPos,$gtPos-$aPos+1); // "<a href='file.htm#id' />"
if (!$hrefPos=strpos(strtolower($anchor),"href=")) continue;
$quote=substr($anchor,$hrefPos+5,1); if ($quote<>"'"&&$quote<>'"') continue;
if (!$endPos=strpos($anchor,$quote,$hrefPos+6)) continue;
$url=substr($anchor,$hrefPos+6,$endPos-$hrefPos-6); if (!$url) continue;
$LineNr=0; $lfPos=0;
do {$linePos=strpos($contents,"\n",$lfPos); $LineNr++;$lfPos=$linePos+1;
   } while ($linePos<$aPos);
$URL=substr($url,0,4)=="http"?"<a class='EXTW' href='$url'>$url</a>":"'$url'";
$Error="\r\n<b><a class='EXT' href='$subdir/$file'>&quot;$FilePath&quot;&#123;$LineNr&#125;</a></b> <font color='red'>dead link to $URL</font>";
$Total++;
if (substr($url,0,1)=="#")  // URL is local fragment.
 {if (@in_array(substr($url,1),$Fragments[$FilePath])) continue;
  else {$Dead++;echo $Error;continue;}
 }
if (strtolower(substr($url,0,4))=="http") // URL is absolute.
{if (!$EXTW) continue; // Skip absolute URL when the checkbox EXTW is clear.
 if (function_exists("stream_context_set_default"))
    stream_context_set_default(array('ssl'=>
      array('verify_peer'=>false,'verify_peer_name'=>false)));
 $Head=@get_headers($url);
 if (strpos($Head[0],"200")) continue;
 if (strpos($Head[0],"301")) continue;
 if (strpos($Head[0],"302")) continue;
 else {$Dead++;echo $Error;continue;}
} // Otherwise URL is relative.
$urlArray=explode('#',$url,2); $urlPath=$urlArray[0];$Fragment=@$urlArray[1];
$urlArray=explode('/',$urlPath,3);
if (isset($urlArray[2]) && $urlArray[2]=="") $urlArray[2]="index.htm";
$SUBSLASH=$subdir?$SLASH:"";
if (isset( $urlArray[2]) && $urlArray[0]=='..') $TargetPath=$EUROASM_HOME.$SLASH.$urlArray[1].$SLASH.$urlArray[2];
if (isset( $urlArray[2]) && $urlArray[0]=='.')  $TargetPath=$EUROASM_HOME.$SLASH.$subdir.$SUBSLASH.$urlArray[1].$SLASH.$urlArray[2];
if (!isset($urlArray[2]) && isset($urlArray[1]) && $urlArray[0]=='..') $TargetPath=$EUROASM_HOME.$SLASH.$urlArray[1];
if (!isset($urlArray[2]) && isset($urlArray[1]) && $urlArray[0]=='.')  $TargetPath=$EUROASM_HOME.$SLASH.$subdir.$SUBSLASH.$urlArray[1];
if (!isset($urlArray[1])) $TargetPath=$EUROASM_HOME.$SLASH.$subdir.$SUBSLASH.$urlArray[0];
if (!$Fragment && file_exists($TargetPath)) continue;
if (!isset($Fragments[$TargetPath])) {$Dead++; echo $Error;continue;}
if ($Fragment &&  in_array($Fragment,$Fragments[$TargetPath])) continue;
if ($Fragment && !in_array($Fragment,$Fragments[$TargetPath])) {$Dead++; echo $Error;continue;}
if (!$Fragment &&  isset($Fragments[$TargetPath])) continue;
if (!$Fragment && !isset($Fragments[$TargetPath])) {$Dead++;echo $Error;continue;continue;}
} // endwhile
} // endForEach $file
} // endForEach $subdir
echo "\r\nChecked $Total links, $Dead of them is dead.</pre>\r\n";
flush();@ob_flush();sleep(1);
echo "</pre><p>Link check finished.</p>";
} // endif LinkCheck pressed.
$checkedEXTW=$EXTW?" checked":"";
echo "<form action='#LinkCheck' method='post'>
Check external links, too<input type='checkbox' name='EXTW'$checkedEXTW
title='External links begin with http...'/>
<input type='submit' name='LinkCheck'
value='Link check'/></form><br class='CLEAR'/><hr/>";


//*****************************************************************************************Build
$Compiler=$EUROASM_HOME.$SLASH."euroasm.exe";
$Command=$EUROASM_HOME.$SLASH."easource".$SLASH."eamake.cmd $TimeStamp";
$EasourceDir=$EUROASM_HOME.$SLASH."easource";
$EasourceFile=$EasourceDir.$SLASH."euroasm.htm";
echo "<h1 id='Build'><a href='#top'>&uarr; Build</a></h1><br class='CLEAR'/>
<p>Make the new version $Version of <q>euroasm.exe</q> with commands</p>
<dl><dd class='PRE'>cd $EasourceDir
$Command</dd></dl>";
if (isset($_REQUEST['Build']))
{echo "<pre>\r\n";
if (!file_exists($Compiler)) echo "<del>Compiler <q>$Compiler</q> not found.</del>\r\n"; else
{if (!file_exists($EasourceFile)) echo"<del>The main source file <q>$EasourceFile</q> not found.</del>\r\n"; else
{$OldDir=getcwd();chdir($EasourceDir);
if (isset($_REQUEST['RALL']))
{$FileArray=scandir($EasourceDir);
 foreach ($FileArray as $file) if (substr($file,-4)==".obj") unlink($EasourceDir.$SLASH.$file);
} // endif Reassemble all modules
@ob_flush();flush();
passthru($Command);chdir($OldDir);
}} echo "</pre>
<p>The build was documented in listing file <a class='EXTW' target='_blank'
title='View the listing in a new window' href='?LstView&amp;Version=$Version'>euroasm.htm.lst</a>.</p>\r\n";
} // endif Build
echo "<form action='#Build' method='post'>
<p>Nominal version: <input type='text' size='8' name='Version' value='$Version'/>
<label title='Check to reassemble all modules even when they are not updated'>
<input type='checkbox' name='RALL' /> Reassemble all modules</label><br/>
<input type='submit' name='Build' value='Build euroasm.exe'/></form>
<br class='CLEAR'/><hr/>";


//*****************************************************************************************Test all
$Compiler=$EUROASM_HOME.$SLASH."easource".$SLASH."euroasm.exe";
$EatestsDir=$EUROASM_HOME.$SLASH."eatests";
$Testman=$EatestsDir.$SLASH."testman.exe";
$Command="$Testman *";
echo "<h1 id='TestAll'><a href='#top'>&uarr; Test all</a></h1><br class='CLEAR'/>
<p>Perform all <a class='EXT' href='./eatests/#TestList'>tests</a> of executable EuroAssembler version compiled to
<q>$Compiler</q>, using executable test manager <q>$Testman</q>.</p>\r\n";
if (isset($_REQUEST['TestAll']))
{echo "<pre>\r\n";
if (!file_exists($Compiler)) echo "<del>Tested version <q>$Compiler</q> not found.</del>\r\n"; else
{if (!file_exists($Testman)) echo"<del>Testmanager <q>$Testman</q> not found.</del>\r\n"; else
{$OldDir=getcwd();chdir($EatestsDir);
 passthru($Command);chdir($OldDir);
}} echo "</pre>\r\n";
} // endif TestAll
echo "<form action='#TestAll' method='post'>
<input type='submit' name='TestAll' value='Test all'/></form>
<br class='CLEAR'/><hr/>";

//*****************************************************************************************Release

echo "<h1 id='Release'><a href='#top'>&uarr; Release</a></h1>
<p>Generate the final distribution file <q>download/euroasm.zip</q>,
its copy <q>download/euroasm.$Version.zip</q>,
and update history in <q>download/index.htm</q>.<p>
<p>All HTML files should be updated, checked and rebuild first.</p>
<blockquote>Script will copy the build <q>$EUROASM_HOME$SLASH"."easource".$SLASH."euroasm.exe</q>
to the home directory <q>$EUROASM_HOME</q>, create a temporary subdirectory
<q>$EUROASM_HOME$SLASH"."release</q>, copy there all relevant
<a class='EXT' href='sitemap.htm'>site files</a>,
touch them with the nominal time and archive them to
<q>$EUROASM_HOME$SLASH"."release".$SLASH."download".$SLASH."euroasm.zip</q>,
carbon-copied to <q>euroasm.$Version.zip</q>.
<br/>Then it will update history in <q>$EUROASM_HOME$SLASH"."download$SLASH"."index.htm</q>
and <q>$EUROASM_HOME$SLASH"."release$SLASH"."download$SLASH"."index.htm</q>.
</blockquote>
<table><tr><th>Updated files</th><th>Begin marker</th><th>End marker</th></tr>
<tr><td><a class='EXT' href='./download/index.htm'>download/index.htm</a></td>
<td><code>&lt;--DOWNLOAD--&gt;</code></td><td><code>&lt;--/DOWNLOAD--&gt;</code></td></tr>
</table>";
if (isset($_REQUEST['Release']))
{
echo "<pre>\r\n";
$Compiler=$EUROASM_HOME.$SLASH."easource".$SLASH."euroasm.exe";
if(!file_exists($Compiler)) echo "<del>Build <q>$Compiler</q> not found.</del>\r\n";
else copy($Compiler,$EUROASM_HOME.$SLASH."euroasm.exe");
$releaseDir=$EUROASM_HOME.$SLASH."release"; // Directory for files to publish.
@EraseDir($releaseDir);
@mkdir($releaseDir);
@mkdir($releaseDir.$SLASH."download");
// Create subarchive release\generate.zip
$FilesToErase=array();
$GenZipFile=$releaseDir.$SLASH."generate.zip";  // Target "generate.zip" will be created in this dir.
$GenZipObj = new ZipArchive();
$GenZipObj->open($GenZipFile,ZipArchive::CREATE);
foreach ($SM as $site=>$properties) // Enumerate files defined in "sitemap.ini" with "/generate.zip".
{if (substr($site,0,14)!=="/generate.zip:") continue;
$generateSite=strtr(substr($site,14),'/',$SLASH); // Internal filename inside "generate.zip".
$generateArray=explode($SLASH,$generateSite,2);
if (isset($generateArray[1])) // If subdirectory $generateArray[0] is present.
 {mkdir($releaseDir.$SLASH.$generateArray[0]);
  touch($releaseDir.$SLASH.$generateArray[0],$TimeStamp);
 } copy($EUROASM_HOME.$SLASH.$generateSite, $releaseDir.$SLASH.$generateSite);
$FilesToErase[]=$releaseDir.$SLASH.$generateSite;
touch($releaseDir.$SLASH.$generateSite,$TimeStamp);
$GenZipObj->addFile($releaseDir.$SLASH.$generateSite, $generateSite);
} // endForEach $site
$GenZipObj->close();
foreach ($FilesToErase as $FileToErase) unlink($FileToErase);
copy($GenZipFile, $EUROASM_HOME.$SLASH."generate.zip");
copy($EUROASM_HOME.$SLASH."easource".$SLASH."euroasm.exe", $EUROASM_HOME.$SLASH."euroasm.exe"); // Final build.
touch($EUROASM_HOME.$SLASH."euroasm.exe",$TimeStamp);

// Create subarchive release/download/eurotool.zip
$FilesToErase=array();
$EutZipFile=$releaseDir.$SLASH."download".$SLASH."eurotool.zip";
$EutZipObj = new ZipArchive();
$EutZipObj->open($EutZipFile,ZipArchive::CREATE);
foreach ($SM as $site=>$properties) // Enumerate files defined in "sitemap.ini".
{if (substr($site,0,23)!=="/download/eurotool.zip:") continue;
$EutFile=substr($site,23);               // e.g. "eurocalc.exe"
copy($EUROASM_HOME.$SLASH."eurotool".$SLASH.$EutFile, $releaseDir.$SLASH.$EutFile);
$FilesToErase[]=$EutFile;
touch($releaseDir.$SLASH.$EutFile, $TimeStamp);
$EutZipObj->addFile($releaseDir.$SLASH.$EutFile, $EutFile);
} // endForEach $site
$EutZipObj->close();
touch($EutZipFile,$TimeStamp);
foreach ($FilesToErase as $FileToErase) unlink($releaseDir.$SLASH.$FileToErase);

copy($EUROASM_HOME.$SLASH."easource".$SLASH."euroasm.exe", $EUROASM_HOME.$SLASH."euroasm.exe"); // Final build.
touch($EUROASM_HOME.$SLASH."euroasm.exe",$TimeStamp);
// Now archive public files to "release/download/euroasm.zip".
$ZipFile=$releaseDir.$SLASH."download".$SLASH."euroasm.zip";
$ZipObj = new ZipArchive();
$ZipObj->open($ZipFile,ZipArchive::CREATE);
foreach ($SM as $site=>$properties) // Enumerate files defined in "sitemap.ini".
{if (substr($site,0,14)=="/generate.zip:") continue; // Already zipped.
 if (substr($site,0,10)=="/download/") continue;
 if (substr($site,0,7)=="/forum/") continue;
 $siteFile=strtr($EUROASM_HOME.$site,'/',$SLASH);
 if (strpos($siteFile,'?')) continue;
 if (strpos($siteFile,'*')) continue;
 if (is_dir($siteFile)) {@mkdir($releaseDir.$site);@touch($releaseDir.$site);continue;}
 if (!file_exists($siteFile)) {echo "\r\n<del>File <q>$siteFile</q> not found.</del>";continue;}
 $releaseFile=$releaseDir.strtr($site,'/',$SLASH);
 copy ($siteFile, $releaseFile);
 touch($releaseFile,$TimeStamp);
 $ZipObj->addFile($releaseFile, substr($site,1));
} // endForEach $site
$TEST_LIST=""; $TNA=array(); $lastN=0;
$TNAS=scandir($EUROASM_HOME.$SLASH."eatests");
foreach ($TNAS as $f)
{if (strlen($f)<>9) continue;
 if (strtolower(substr($f,-4))<>".htm") continue;
 if (strtolower(substr($f,0,1))<>"t") continue;
 $TNA[]=strtolower($f);
}sort($TNA);
foreach ($TNA as $test)
{$releaseFile=$releaseDir.$SLASH."eatests".$SLASH.$test;
copy ($EUROASM_HOME.$SLASH."eatests".$SLASH.$test, $releaseFile);
 touch ($releaseFile,$TimeStamp);
 $ZipObj->addFile($releaseFile, "eatests/$test");
} // endForEach $test
$ZipObj->close();
touch($ZipFile,$TimeStamp);
$ZipFileVersion=substr($ZipFile,0,-3).$Version.".zip";
copy($ZipFile,$ZipFileVersion);
touch($ZipFileVersion,$TimeStamp);
$History="
<!--/DOWNLOAD-->
<dl><dt>Version $Version</dt><dd>
<b>Download:</b> <a class=\"EXTW\" href=\"euroasm.$Version.zip\">euroasm.$Version.zip</a>
<br/><b>Release date: </b>".date("Y M j",$TimeStamp)."
<br/><b>TimeStamp: </b>$TimeStamp
<br/><b>File size: </b>".filesize($ZipFileVersion)."
<br/><b>File hash MD5: </b>".strtoupper(md5_file($ZipFileVersion))."
<br/><b>What's new: </b>
$WhatsNew
</dd></dl>
\r\n";
echo "\r\n";
Update($EUROASM_HOME.$SLASH."download".$SLASH."index.htm",$History,"DOWNLOAD");
copy($EUROASM_HOME.$SLASH."download".$SLASH."index.htm", $releaseDir.$SLASH."download".$SLASH."index.htm");
touch($releaseDir.$SLASH."download".$SLASH."index.htm",$TimeStamp);
file_put_contents($releaseDir.$SLASH."version".$SLASH."index.htm",$Version);
touch($releaseDir.$SLASH."version".$SLASH."index.htm",$TimeStamp);

echo "</pre><p>New release $Version was generated. TimeStamp=$TimeStamp.</p>";
} // endif Release pressed.
echo "<form action='#Release' method='post'>
<p>What's new in this release:
<textarea name='WhatsNew' rows='8' placeholder='Bugs fixed in this release:'>".htmlspecialchars($WhatsNew,ENT_QUOTES)."
</textarea></p>
<p>Nominal version: <input type='text' size='8' name='Version' value='$Version'/></p>
<input type='submit' name='Release' value='Create the release'/></form>
<br class='CLEAR'/><hr/>";
//****************** TAILMENU *********************************************************************
echo"<a href='#top'>&#x25B2;Back to the top&#x25B2;</a>
</body></html>";

//***************** Functions used in the script "generate.php", alphabetical order **********************

function Decolon($field) // Remove trailing colons from the string $fiels.
{$f=$field; while (substr($f,-1)==":") $f=substr($f,0,-1);
return $f;} // endFn Decolon


function EraseDir($dir)
{if (is_dir($dir))
  {$objects=scandir($dir);
   foreach ($objects as $object)
   {if ($object=="." || $object=="..") continue;
    if (is_dir($dir."/".$object))
       EraseDir($dir."/".$object);
    else unlink($dir."/".$object);
   } rmdir($dir);
}} // endFn EraseDir

function FnLink($id,$IdSearch,$IdReplace,$module="") // Converts Procedure name to a link.
{// E.g. for $id="SssCreate@LT" returns anchor "sss.htm#SssCreateatLT".
 // The anchor is internal when detected module equals $module.
$src=strtolower($id[$i=0]);
for ($i=1;$i<strlen($id);$i++) {$c=substr($id,$i,1);
if ((ord($c)<ord('a'))||(ord($c)>ord('z'))) break; else $src.=$c;
}if ($src=="pseudopc") $src="pseudo";
$safeId=str_replace($IdSearch,$IdReplace,$id);
if ($src==$module) return "<a href=\"#$safeId\">$id</a>\r\n";
else return "<a class=\"EXT\" href=\"$src.htm#$safeId\">$id</a>\r\n";
} // endFn FnLink

function GenHeader($BodyClass,$Version,$Language,$Title,$Description,$Home='.',$Redirect="")
{return "<!doctype html><html lang='$Language'><head>
<meta http-equiv='Content-Type' content='text/html; charset=utf-8'/>
<meta name='viewport' content='width=device-width, initial-scale=1.0, maximum-scale=2.0, user-scalable=yes'>
<meta name='robots' content='ALL,FOLLOW'/>
<meta name='description' content='$Description'/>
<meta name='version' content='$Version'/>
<meta name='author' content='Pavel vitsoft Šrubař'/>
<link rel='stylesheet' href='$Home/euroasm.css' type='text/css'/>
<link rel='shortcut icon' href='$Home/favicon.ico'/>$Redirect
<title>$Title</title>
</head>
<body class='$BodyClass' id='top'><div class='HEADMENU'><table>
<tr><td rowspan='2' title='&euro;ASM - assembler and linker'><img src='$Home/favicon.ico' alt='EuroAssembler' />
<td><a href='$Home/index.htm' title='Alphabetical index of all &euro;ASM elements, directives and instructions'>Index</a></td>
<td><a href='$Home/eadoc/' class='EADOC' title='Documentation of EuroAssembler'>Manual</a></td>
<td><a href='https://euroassembler.eu/download/' title='History &amp; download of the latest and previous versions'>Download</a></td>
<td><a href='$Home/easource/' class='EASOURCE' title='Source files of EuroAssembler itself'>Source</a></td>
<td><a href='$Home/maclib/' class='MACLIB' title='Macro libraries shipped with &euro;ASM'>Macros</a></td>
<td rowspan='2' title='Find the searched token in any text file on this site'>
<form method='post' action='$Home/search.php' enctype='multipart/form-data' accept-charset='utf-8'>
<input type='text' id='q' placeholder='Searched word(s)' name='q' value=''/>
<br/><label title='Check the box to find the expression even if it is surrounded by other letters | digits.'>
<input type='checkbox' name='EW'/><small>Embedded word</small></label>
<br/><label title='Check the box for case-insensitive search.'>
<input type='checkbox' name='CI'/><small>Case ins.</small></label>
<input type='submit' title='Search for the specified word|expression in all site files.' name='find' value='Search'/>
</form></td></tr><tr>
<td><a href='$Home/sitemap.htm' title='List of directories and files on this site'>Sitemap</a></td>
<td><a href='$Home/eadoc/links.htm' class='EADOC' title='References and external links to resources used in EuroAssembler developement'>Links</a></td>
<td><a href='https://euroassembler.eu/forum/' title='Discussion forum concerning EuroAssembler'>Forum</a></td>
<td><a href='$Home/eatests/' class='EATESTS' title='Program snippets for testing the function of &euro;ASM'>Tests</a></td>
<td><a href='$Home/objlib/' class='OBJLIB' title='Skeletons and sample objects and projects shipped with &euro;ASM'>Projects</a></td>
</tr></table></div>";
} // endFn GenHeader

function GetSitemap($FileName) // Returns an array from "sitemap.ini" completed with all omitted properties.
{$SM=parse_ini_file($FileName,true);
uksort($SM,"SortByDir"); // Sort by directory and filename.
/*  AutoProperties marked with *= will be derived from other properties if omitted in "sitemap.ini".
;   Other properties need to be specified explicitely in "sitemap.ini".
; Anchor *= Complete link to the file with Tag, AnchorClass, Website.
; AnchorClass *= "EXTW" if Website is not local, otherwise "EXT".
; BodyClass *= HTML body class. Derived from Subdir if omitted.
; Contains = List of macros in maclib, projects in project samples.
; Description = Description visible on "sitemap.htm" overview.
; EaClass = Object class in EuroAssembler sources.
; Realm = Realm of macrolibrary objects.
; File *= filename.ext without path, e.g. "stm.htm".
; IiCategory = One-letter shortcut of machine instruction category, e.g. "A".
; Language *= Defaults to "en". Used with translated pages.
; Pformat = Program format of output file, e.g. "LIBOMF".
; PseudoClass = "yes" if not a real class/structure.
; Registers = Range of machine registers used by the IiCategory.
; Representation = Representation of object class in EuroAssembler sources.
; SourceName = Filename without path and extension if it should be assembled, e.g. "stm".
; Subdir *= $EUROASM_HOME subdirectory without slashes, e.g. "easource" or "".
; Tag *= "small" for zip:files, otherwise "code".
; Title *= HTML title value. Defaults to File without extension.
; Tx *= "th" when it is directory, "td" when it is leaf file.
; Website = "http://euroassembler.eu" if not distributed in "euroasm.zip", otherwise "." or empty.
*/
$ManualProperties=array("Anchor","AnchorClass","BodyClass","Contains","Description","EaClass","Family","IiCategory",
     "Language","Pformat","PseudoClass","Realm","Registers","Representation","SourceName","Title","Tx","Tag","Website");
foreach ($SM as $SITE=>$SA)
{foreach ($ManualProperties as $property) if (!isset($SM[$SITE][$property])) $SM[$SITE][$property]="";
 $FA=explode('/',$SITE);
 $SM[$SITE]['File']=isset($FA[2])?$FA[2]:@$FA[1];
 $SM[$SITE]['Subdir']=isset($FA[2])?$FA[1]:"";
 if (!$SM[$SITE]['Website']) $SM[$SITE]['Website']='.';
 if (!$SM[$SITE]['AnchorClass']) $SM[$SITE]['AnchorClass']=$SM[$SITE]['Website']<>'.'?'EXTW':'EXT';
 if (!isset($SM[$SITE]['PseudoClass'])) $SM[$SITE]['PseudoClass']=$SM[$SITE]['PseudoClass']=='yes';
 if (!$SM[$SITE]['BodyClass']) switch ($SM[$SITE]['Subdir'])
  {case 'easource':$SM[$SITE]['BodyClass']='SOURCE';break;
   case 'eadoc'   :$SM[$SITE]['BodyClass']='MAN';   break;
   case 'eatests' :$SM[$SITE]['BodyClass']='TEST';  break;
   case 'maclib'  :$SM[$SITE]['BodyClass']='MACLIB';break;
   default        :$SM[$SITE]['BodyClass']='MAN';
  } // endswitch
 if (!$SM[$SITE]['Language']) $SM[$SITE]['Language']="en";
 if (!$SM[$SITE]['Title']) $SM[$SITE]['Title']=$SM[$SITE]['File'];
 if (!$SM[$SITE]['Tx']) $SM[$SITE]['Tx']=isset($FA[1])&&!$FA[1]||isset($FA[2])&&!$FA[2]?'th':'td';

 if (!$SM[$SITE]['Tag']) $SM[$SITE]['Tag']=strpos($SITE,':')?'small':'code';
 $href=$SM[$SITE]['Website'].$SITE;
 if (!$SM[$SITE]['Anchor']) $SM[$SITE]['Anchor']="<".$SM[$SITE]['Tag'].
    "><a class='".$SM[$SITE]['AnchorClass']."' href='$href'>$SITE</a></".$SM[$SITE]['Tag'].">";
if (strpos($SITE,'?')||strpos($SITE,'*')||strpos($SITE,':')) $SM[$SITE]['Anchor']="<".$SM[$SITE]['Tag'].
         ">$SITE</".$SM[$SITE]['Tag'].">";
} return $SM;} // endFn GetSiteMap

function GetTimeStamp($Version)
{return mktime(0,0,0,substr($Version,4,2),substr($Version,6,2),substr($Version,0,4));
} // endFn GetTimeStamp

function GetVersion()
{date_default_timezone_set('UTC');
if (!$Version=(integer)@$_REQUEST['Version'])
$Version=date("Ymd", mktime(0,0,0,date("n"),date("j"),date("Y")));
return $Version;
} // endFn GetVersion

function IndexDict($dict,$DictLabel,$Class,$Family,$ManId) // Return index array to be merged.
{$Family_=substr("$Family                ",0,16);
echo "Indexing $Family_ $DictLabel\r\n";flush();@ob_flush();
$Index=array(); $family=" <small>($Family)</small>";
$Parsed=ParseDict($dict,$DictLabel);
foreach ($Parsed as $Term)
{if ($DictLabel=="DictAttributes::") $Term=$Term."#";
 if ($DictLabel=="DictFpConstants::") $Term="#".$Term;
 if ($Class=="XKN") $Term=$Term.'=';
$Index[$Term.$family]="<a class='$Class' href='./eadoc/index.htm#$ManId'>$Term$family</a>";
} return $Index;} // endFn IndexDict

function IndexList($FileName,$pcList,$Class,$Family,$ManId) // Return index array to be merged.
{$Family_=substr("$Family                ",0,16);
echo "Indexing $Family_ $pcList\r\n";flush();@ob_flush();
$Index=array(); $family=" <small>($Family)</small>";
$Parsed=ParseList($FileName,$pcList);
foreach ($Parsed as $Term)
{if ($Class=="XSV") $Term="%^".$Term;
 if ($Class=="XKN") $Term=$Term.'=';
$Index[$Term.$family]="<a class='$Class' href='./eadoc/index.htm#$ManId'>$Term$family</a>";
} return $Index;} // endFn IndexList

function IndexII($EUROASM_HOME,$SLASH) // Returns array of Intel instructions.
{$Parsed=array();$family=" <small>(instr.)</small>";
$SM=GetSitemap($EUROASM_HOME.$SLASH."sitemap.ini"); // Load files information.
$easourceSubdir="/easource/";
foreach ($SM as $site=>$Properties)
{$Cat=$Properties['IiCategory']; $cat=strtolower($Cat);
if (substr($site,0,10)<>$easourceSubdir ||strlen($Cat)<>1) continue;
$Description=$Properties['Representation'];
$FileName=strtr($EUROASM_HOME.$site,'/',$SLASH);
echo "Indexing $FileName\r\n";flush();@ob_flush();
$Mnemos=ParseList($FileName,"%Ii$cat"."List");
foreach ($Mnemos as $Mnemo)
 $Parsed[$Mnemo.$family]="<a class='XII' title='$Description' href='.$site#Ii$cat$Mnemo'>$Mnemo$family</a>";
} // endforeach $site
return $Parsed; } // endFn IndexII

function IndexMaclib($EUROASM_HOME,$SLASH) // Returns array of macros.
{$Parsed=array();
global $IdSearch,$IdReplace;
$SM=GetSitemap($EUROASM_HOME.$SLASH."sitemap.ini"); // Load files information.
$maclibSubdir="/maclib/";
foreach ($SM as $site=>$Properties)
{if (substr($site,0,8)<>$maclibSubdir ||$site==$maclibSubdir) continue;
$Description=$Properties['Description'];
$FileName=strtr($EUROASM_HOME.$site,'/',$SLASH);
$ES=explode('/',$site);$lib=substr($ES[2],0,-4); // maclib name, e.g. "dosapi".
echo "Indexing $FileName\r\n";flush();@ob_flush();
if (!$Lines=file($FileName)) {echo "<del>error reading &quot;$FileName&quot;</del>\r\n";return $Parsed;}
foreach ($Lines as $Line)
{$line=trim($Line);
if (!stripos($line,"%MACRO")) continue;
$Fields=explode(" ",$line,2);
while (!$Fields[0]) array_shift($Fields);
$MacroName=$Fields[0];
$MacroId=str_replace($IdSearch,$IdReplace,$MacroName);
$Parsed[$MacroName.$lib]="<a class='XMI' title='$Description' href='.$site#$MacroId'>$MacroName <small>($lib)</small></a>";
} // endforeach $Line
} // endforeach $site
return $Parsed;} // endFn IndexMaclib

function IndexManual($FileName) // Returns array of values.
{echo "Indexing Manual ";
$File=file_get_contents($FileName);
$idPos=$titlePos=$ltPos=0;$gtPos=1;
$Parsed=array();
while ($ltPos=mb_strpos($File,"<",$gtPos))
{if (!$gtPos=mb_strpos($File,">",$ltPos+1)) return $Parsed;
$Tag=mb_substr($File,$ltPos,$gtPos-$ltPos+1);
if (!$titlePos=mb_strpos($Tag,"title=")) continue; // Skip tag without title=.
if (!$idPos=mb_strpos($Tag,"id=")) continue; // Skip tag without id=.
echo ".";flush();@ob_flush();
$quote=substr($Tag,$titlePos+6,1);
$titleEndPos=mb_strpos($Tag,$quote,$titlePos+7);
$Title=trim(mb_substr($Tag,$titlePos+7,$titleEndPos-$titlePos-7));
$quote=substr($Tag,$idPos+3,1);
$idEndPos=mb_strpos($Tag,$quote,$idPos+4);
$Id=trim(mb_substr($Tag,$idPos+4,$idEndPos-$idPos-4));
$Parsed[$Title]="<a class='XLG' href='./eadoc/index.htm#$Id'>$Title</a>";
} // endwhile
echo "\r\n";return $Parsed;} // endFn IndexManual

function OneColumn($XCOL,$COL)
{$Index="<div class='COL$COL"."OF3'>\r\n";
 foreach ($XCOL as $Title=>$Anchor) $Index.="$Anchor\r\n<br/>";
 $Index.="</div>\r\n";
return $Index;} // endfunction OneColumn

function OneLetter($X,$c) // $c is one letter 'A'..'Z' or ''.
{$Index=""; $Xc=array();
if ($c) {foreach ($X as $Title=>$Anchor) if (strtoupper($Title[0])==$c) $Xc[$Title]=$Anchor;
         $Index.="<br class='CLEAR'/><h2 id='$c'><a href='#top'>&uarr; $c</a></h2>\r\n";
        } else
         foreach ($X as $Title=>$Anchor)
            if (strtoupper($Title[0])<'A'||strtoupper($Title[0])>'Z') $Xc[$Title]=$Anchor;
$n=count($Xc); $n3=(integer)$n/3;
$XCOL1=$XCOL2=$XCOL3=array(); $i=0;
foreach ($Xc as $Title=>$Anchor)
{if ($i<$n3)                $XCOL1[$Title]=$Anchor;
 if ($i>=$n3&&$i<($n3+$n3)) $XCOL2[$Title]=$Anchor;
 if ($i>=$n3+$n3)           $XCOL3[$Title]=$Anchor;
 $i++;
}
$Index.=OneColumn($XCOL1,1);
$Index.=OneColumn($XCOL2,2);
$Index.=OneColumn($XCOL3,3);
return $Index;} //endfunction OneLetter

function Parse($line,$lineNr=0) // Simplified statement parser. Returns an array with parsed stm.
{$instructions=array('Procedure','EndProcedure','Invoke','PROC','ENDP','ENDPROC','CALL');
if (substr($line,0,1)=="<" || substr($line,0,1)==";") // If the $line is comment.
  return array('lineNr'=>$lineNr,'label'=>'','operation'=>'','operand'=>'');
$F1=$F2=$F3="";$Phase=0; $lineSize=strlen($line);
for ($i=0;$i<$lineSize;$i++)
{$c=substr($line,$i,1);
if ($c==' ' ||$c==':')  // separator
 switch ($Phase)
 {case 0:$Phase=1;break; // eof F1
  case 2:$Phase=3;break; // eof F2
  case 4:break 2;    // end of parse
 } else   // letter,digit,dot
 switch ($Phase)
 {case 0:$F1.=$c;break;
  case 1:$Phase=2;
  case 2:$F2.=$c;break;
  case 3:$Phase=4;
  case 4:$F3.=$c;break;
 }
} // endfor $i
if (in_array($F1,$instructions)) {$F3=$F2;$F2=$F1;$F1="";}
$OA=explode(',',$F3); // Operand list.
$F3=Decolon(trim($OA[0]));
if ($F2=='PROC' && strpos($F1,'.')!==false) $F2=''; // omit local PROC.
if ($F2=='ENDP' && strpos($F3,'.')!==false) $F2=''; // omit local ENDP.
if ($F2=='ENDPROC' && strpos($F3,'.')!==false) $F2=''; // omit local ENDPROC.
return array('lineNr'=>$lineNr,'label'=>$F1,'operation'=>$F2,'operand'=>$F3);
} // endFn Parse

function ParseDict($FileName,$DictLabel) // Returns array of values.
{$Parsed=array();
if (!$Lines=file($FileName)) {echo "<del>error reading &quot;$FileName&quot;</del>\r\n";return $Parsed;}
$found=false;
foreach ($Lines as $Line)
{$line=trim($Line);
if (!$found) {if (substr($line,0,strlen($DictLabel))==$DictLabel) $found=true; continue;}
if (substr($line,0,5)<>"Dict ") continue;
$Params=explode(",",substr($line,5),3);
if (trim($Params[0])=="End") return $Parsed;
$Value=trim($Params[1]); $DequotedValue=trim($Value,"'\"");
if (substr($DequotedValue,0,2)=="%%")
     $Parsed[]=substr($DequotedValue,1); // Convert %%PSEUDO to %PSEUDO.
else if ($DequotedValue!="%PURPOSE") $Parsed[]=$DequotedValue;
} // endforeach $Line
echo "<del>$DictLabel not found in &quot;$FileName&quot;.</del>\r\n";return $Parsed;
} // endFn ParseDict

function ParseDL($dl) // Parse description list "<dl>..</dl>" into array.
{$DL=array();$pos=0; $max=0; $dlSize=strlen($dl);
while ($dtBeg=strpos($dl,'<dt>',$pos))
{$dtEnd=strpos($dl,'</dt>',$dtBeg); if (!$dtEnd) die("<del>ParseDL missing /dt</del>".print_r($dl));
$ddBeg=strpos($dl,'<dd',$dtEnd);  if (!$ddBeg) die("<del>ParseDL missing dd</del>".print_r($dl));
$ddEnd=strpos($dl,'</dd>',$ddBeg); if (!$ddEnd) die("<del>ParseDL missing /dd</del>".print_r($dl));
$DL[trim(substr($dl,$dtBeg+4,$dtEnd-$dtBeg-4))]=trim(substr($dl,$ddBeg+4,$ddEnd-$ddBeg-4));
$pos=$ddEnd+4;
if (++$max >15) die ("<del>ParseDL max number of dt exceeded.
max=$max dlSize=$dlSize dtBeg=$dtBeg dtEnd=$dtEnd ddBeg=$ddBeg ddEnd=$ddEnd pos=$pos</del>".
print_r($DL,1));
}return $DL;
} // endFn ParseDL

function ParseList($FileName,$pcList) // Returns array of values.
{$Parsed=array();
if (!$Lines=file($FileName)) {echo "<del>error reading &quot;$FileName&quot;</del>\r\n";return $Parsed;}
$found=$cont=false;
foreach ($Lines as $Line)
{if ($found && !$cont) return $Parsed;
$line=trim($Line);
if (!$found) {if (substr($line,0,strlen($pcList))==$pcList) $found=$cont=true;else continue;}
if (!$cont) return $Parsed;
$cont=false;
$pcSET=explode(" ",$line,3);
while (@!$pcSET[0]) array_shift($pcSET);
if ($pcSET[0]==$pcList)
 {array_shift($pcSET); // Remove %pcList
  while (@!$pcSET[0]) array_shift($pcSET);
  $pcSET[0]=trim($pcSET[0]);
  if (substr($pcSET[0],0,4)=='%SET') $pcSET[0]=trim(substr($pcSET[0],5));  // remove %SET
 }$line=trim(implode(" ",$pcSET));
$Params=explode(",",$line);
while ($param=@trim($Params[0]))
 {if ($param{0}=="\\") {$cont=true; continue 2;} // statement line continuation.
  if ($param{0}<>"<") $Parsed[]=$param; array_shift($Params);
 } // endwhile $param
} // endforeach $Line
if (!$found) echo "<del>$pcList not found in &quot;$FileName&quot;.</del>\r\n";
return $Parsed; } // endFn ParseList

function ShiftGenerations($FileName)
{// Creates backup copy of $FileName. Returns "$FileName.0.prev".
@unlink("$FileName.9.prev"); // Discard the oldes generation, if exists.
for ($n=9;$n>0;$n--)
{$e=$n-1; @rename("$FileName.$e.prev","$FileName.$n.prev");}
@copy("$FileName","$FileName.0.prev"); return "$FileName.0.prev";
} // endFn ShiftGenerations

function SortByDir($a,$b) // Callback from uksort.
{$A=explode('/',$a); $B=explode('/',$b);
 if (isset($A[2])&&!isset($B[2])) return +1;
 if (!isset($A[2])&&isset($B[2])) return -1;
 if (isset($A[2])&&isset($B[2]))  return $A[1].$A[2]>$B[1].$B[2]?+1:-1;
 if (!isset($A[2])&&!isset($B[2]))return $A[1]>$B[1]?+1:-1;
} // endFn SortByDir

function SortCaseInsensitive($a,$b) // Callback from uksort.
{$A=strtoupper($a); $B=strtoupper($b);
 if ($A>$B) return +1;
 if ($A<$B) return -1;
 if ($a>$b) return +1;
 if ($a<$b) return -1;
 return 0;
} // endFn SortCaseInsensitive

function TstLink($Test) // Converts $Test name to a link.
{$test=strtolower($Test);
return "<a class=\"EXT\" href=\"../eatests/$test.htm\">$test</a>\r\n";
} // endFn TstLink

function UnparseDL($DL,$id,$DA) // Write Procedure-documentation description list "<dl>..</dl>".
{$r="<dl id=\"$id\">";
foreach ($DL as $dt=>$dd)
{if (!$dd) continue;
 if ($dt=='Example')
 {if (substr($dd,0,12)=='class="PRE">') $dd=substr($dd,12);
  $r.="\r\n<dt>Example</dt><dd class=\"PRE\">$dd</dd>"; continue;
 }$r.="\r\n<dt>$dt</dt>\r\n<dd>$dd</dd>";
}return "$r\r\n</dl>";
} // endFn UnparseDL

function Update($FileName,$NewText,$MARKER)
{// Replace the contents in file between markers with $NewText and write to $NewFileName.
$NewFileName=$FileName; $OldFileName=ShiftGenerations($NewFileName); $NewEndMarker="";
$BegMarker="<!--$MARKER-->"; $EndMarker="<!--/$MARKER-->";
echo "Updating file \"$NewFileName\" ... ";flush();@ob_flush();//sleep(1);
if (!$InpText=@file_get_contents($OldFileName)) {echo "<del>File \"$OldFileName\" not found.</del>\r\n";return false;}
if (($BegPos=strpos($InpText,$BegMarker,0))===false)
 {echo "<del>Marker <code>".htmlentities($BegMarker).
  "</code> was not found in \"$OldFileName\".</del>\r\n";return false;
 }
if (!$EndPos=strpos($InpText,$EndMarker,$BegPos))
 {echo "<del>Marker <code>".htmlentities($EndMarker).
       "</code> was not found in \"$OldFileName\".</del>\r\n";return false;
 } $BegComment="
<!--Contents between markers ".strtr($BegMarker,'<>-','{}=')." and ".strtr($EndMarker,'<>-','{}=').
" was generated by \"".pathinfo($_SERVER['PHP_SELF'],PATHINFO_BASENAME)."\".-->\r\n";
if (!@file_put_contents($NewFileName,substr($InpText,0,$BegPos+strlen($BegMarker)).$BegComment
     .$NewText.$NewEndMarker.substr($InpText,$EndPos)))
     {echo "<del>Error writing to \"$NewFileName\".</del>\r\n";return false;}
else echo "successfully.\r\n"; return true;
} // endFn Update

function UpdateHead($FileName,$NewText)
{// Replace HTML head and the main menu on top of the webpage.
$NewFileName=$FileName; $OldFileName=ShiftGenerations($NewFileName);
$EndMarker="<!--/HEADMENU-->";
$EndComment="\r\n<!--Contents above the marker ".strtr($EndMarker,'<>-','{}=').
" was generated by \"".pathinfo($_SERVER['PHP_SELF'],PATHINFO_BASENAME)."\".-->\r\n$EndMarker\r\n";
echo "Updating file \"$NewFileName\" ... ";flush();@ob_flush();
if (!$InpText=@file_get_contents($OldFileName)) {echo "<del>File \"$OldFileName\" not found.</del>\r\n";return false;}
if ($EndPos=strpos($InpText,$EndMarker)) $EndPos+=2+strlen($EndMarker);
else
 if (!$EndPos=strpos($InpText,"<h1"))
  if (!$EndPos=strpos($InpText,"<big"))
    {echo "None of markers <code>".htmlentities("$EndMarker, <big>, <h1>").
       "</code> was found in \"$OldFileName\".</del>\r\n";return false;
    }
if (!@file_put_contents($NewFileName,$NewText.$EndComment.substr($InpText,$EndPos)))
     {echo "<del>Error writing to \"$NewFileName\".</del>\r\n";return false;}
else echo "successfully.\r\n"; return true;
} // endFn UpdateHead

function UpdateHtmlHead($EUROASM_HOME,$SLASH,$subdir,$file,$SM,$Version,$Redirect)
{$Site=@$SM[$subdir.$SLASH.$file];
 if (isset($Site['BodyClass'])) $BodyClass=$Site['BodyClass'];
 else switch ($subdir)
  {case 'easource':$BodyClass="EASOURCE";break;
   case 'eatests' :$BodyClass="EATESTS"; break;
   case 'eadoc'   :$BodyClass="EADOC";   break;
   case 'maclib'  :$BodyClass="MACLIB";  break;
   case ''        :$BodyClass="EAHOME";  break;
   default: $BodyClass="OBJLIB";
  } // endswitch $subdir
 if (isset($Site['Title'])) $Site['Title'];
 else switch ($subdir)
  {case 'easource':$Title="$file source file";  break;
   case 'eatests' :$Title="$file test file";    break;
   case 'eadoc'   :$Title="$file manual";       break;
   case 'maclib'  :$Title="$file macro library";break;
   case 'objlib'  :$Title="$file object library";break;
   default: $Title=$file;
  } // endswitch $subdir
  if (isset($Site['Description'])) $Site['Description'];
 else switch ($subdir)
  {case 'easource':$Description="$file source file";  break;
   case 'eatests' :$Description="$file test file";    break;
   //case 'eadoc'   :$Description="$file manual";       break;
   case 'maclib'  :$Description="$file macro library";break;
   default: $Description="&euro;ASM file $file";
  } // endswitch $subdir
 $Language=isset($Site['Language'])?$Site['Language']:"en";
 $Home=$subdir?"..":".";
 $NewHead=GenHeader($BodyClass,$Version,$Language,$Title,$Description,$Home,$Redirect);
 if ($subdir) $subdir.=$SLASH;
 $filepath=$EUROASM_HOME.$SLASH.$subdir.$file;
 UpdateHead($filepath,$NewHead);
 flush();@ob_flush();
} // endFn UpdateHtmlHead

function UpdateTail($FileName,$NewText)
{// Replace the tail of HTML page.
$Output=$FileName; $Input=ShiftGenerations($Output);
$BegMarker="<!--TAILMENU-->";
$BegComment="\r\n<!--Contents below the marker ".strtr($BegMarker,'<>-','{}=').
" was generated by \"".pathinfo($_SERVER['PHP_SELF'],PATHINFO_BASENAME)."\".-->\r\n";
echo "\r\nUpdating file \"$Output\" ... ";flush();@ob_flush();
if (!$InpText=@file_get_contents($Input)) {echo "\r\n<del>File \"$Input\" not found.</del>";return false;}
if (!$BegPos=strpos($InpText,$BegMarker))
 if (!$BegPos=strpos($InpText,"</body>"))
    {echo "\r\n<del>None of markers <code>".htmlentities("$BegMarker, </body>").
       "</code> was found in \"$Input\".</del>";return false;
    }
if (!@file_put_contents($Output,substr($InpText,0,$BegPos).$BegMarker.$BegComment.$NewText))
     {echo "\r\n<del>Cannot write to \"$Output\".</del>";return false;}
else echo "successfully."; return true;
} // endFn UpdateTail

function GenerateCrib($FileName)
{// Create PNG image $FileName size A4 210*297 mm, 120 dpi
$W=992; $H=1404; $M=40; $P=16;  // Width, Height, Margin, Padding
if (!$Img=imagecreatetruecolor($W,$H)) return false;
$Palete['W']=imagecolorallocate($Img,0xFF,0xFF,0xFF); // white
$Palete['Y']=imagecolorallocate($Img,0xFF,0xFF,0xFD); // yellow
$Palete['G']=imagecolorallocate($Img,0x80,0x80,0x80); // gray
$Palete['N']=imagecolorallocate($Img,0x00,0x60,0x80); // XKN key Names
$Palete['V']=imagecolorallocate($Img,0xC0,0x60,0x00); // XKV key Values
$Palete['P']=imagecolorallocate($Img,0x80,0x00,0x00); // XPI Pseudoinstructions
$Palete['I']=imagecolorallocate($Img,0x00,0x00,0x00); // XII Machine instructions
$Palete['S']=imagecolorallocate($Img,0x80,0x00,0x80); // XSV System %^variables
$Palete['L']=imagecolorallocate($Img,0x80,0x40,0x00); // XLG Language
$Palete['T']=imagecolorallocate($Img,0x00,0x60,0x80); // XAT Attribute
imagefilledrectangle($Img,0,0,$W-1,$H-1,$Palete['W']); // White background.
imagefilledrectangle($Img,$M,$M,$W-$M,$H/2-$M,$Palete['Y']);
imagerectangle($Img,$M,$M,$W-$M, $H/2-$M,$Palete['G']); // Two yellow frames.
imagefilledrectangle($Img,$M,$H/2+$M,$W-$M,$H-$M,$Palete['Y']);
imagerectangle($Img,$M,$H/2+$M,$W-$M,$H-$M,$Palete['G']);

function ImageText($Img,$X,$Y,$Text,$Palete)
{// Write $Text to image, interpreting pseudocommands escaped with tilde.
// ~1 .. ~5  change font to 1 .. 5.
// ~A .. ~Z  change color to $Palete['A'] .. $Palete['Z'].
// ~~        Write a single tilde.
$line="";$font=5;$color=$Palete['P'];$x=$X;$y=$Y;
for($i=0;$i<strlen($Text);$i++)
{$c=$Text[$i];
switch ($c) {
case "\n":imagestring($Img,$font,$x,$y,$line,$color);$x=$X;$y+=imagefontheight($font);$line="";
case "\r":break;
case "~": if ($Text[$i+1]=='~') {$line.='~';$i++; break;}
          if ($line)
      {imagestring($Img,$font,$x,$y,$line,$color);$x+=strlen($line)*imagefontwidth($font);$line="";}
      $n=$Text[++$i];if ($n<=5&&$n>=1) $font=$n; else $color=$Palete[$n];break;
default:$line.=$c;
} // endSwitch $c
}} // endFn ImageText

$Instructions='~5~L                     Pseudoinstructions & keyword parameters

~3~PEUROASM ~3~NABM=~2~VOFF,~3~N AES=~2~VOFF~3~N, AMD=~2~VOFF~3~N, AutoAlign=~2~VON~3~N, AutoSegment=~2~VON~3~N, CET=~2~VOFF~3~N, CodePage=~2~VUTF-8~3~N, CPU=~2~V586|086|186|286|386|486|686|X64~3~N, \
      CYRIX=~2~VOFF~3~N, D3NOW=~2~VOFF~3~N, Debug=~2~VOFF~3~N, DisplayEnc=~2~VOFF~3~N, DisplayStm=~2~VOFF~3~N, Dump=~2~VON~3~N, DumpAll=~2~VOFF~3~N, DumpWidth=~2~V28~3~N, EVEX=~2~VOFF~3~N, FMA=~2~VOFF~3~N, \
      FPU=~2~VOFF~3~N, IncludePath=~2~V".;./maclib;../maclib;"~3~N, Interpreter=~2~V"/lib/ld-linux.so.2",~3~N LinkPath=~2~V".;./objlib;../objlib;"~3~N, List=~2~VON~3~N, \
      ListFile=~2~V"%^SourceName%^SourceExt.lst"~3~N, ListInclude=~2~VOFF~3~N, ListMacro=~2~VOFF~3~N, ListRepeat=~2~VOFF~3~N, ListVar=~2~VOFF~3~N, LWP=~2~VOFF~3~N, MaxInclusions=~2~V64~3~N, \
      MaxLinks=~2~V64~3~N, MMX=~2~VOFF~3~N, MPX=~2~VOFF ~3~N, MVEX=~2~VOFF~3~N, NoWarn=, PRIV=~2~VOFF~3~N, Profile=~2~VOFF~3~N, PROT=~2~VOFF~3~N, RunPath=~2~V".;./objlib;../objlib;"~3~N, SGX=~2~VOFF~3~N, \
      SHA=~2~VOFF~3~N, SIMD=~2~V OFF|SSE1|SSE2|SSE3|SSSE3|SSE4|SSE4.1|SSE4.2|AVX|AVX2|AVX512~3~N, SPEC=~2~VOFF~3~N, SVM=~2~VOFF~3~N, TimeStamp=~2~V-1~3~N, TSX=~2~VOFF~3~N, UNDOC=~2~VOFF~3~N
      Unicode=~2~VOFF~3~N, VIA=~2~VOFF~3~N, VMX=~2~VOFF~3~N, Warn=~2~V0000..3999,~3~N XOP=~2~VOFF~3~N

~3~PPROGRAM~3~N DllCharacteristics=~2~V0x0000~3~N, Entry=, FileAlign=, Format=~2~VBIN|BOOT|COFF|COM|DLL|ELF|ELFX|ELFSO|OMF|LIBCOF|LIBOMF|MZ|PE|~3~N, \
      IconFile=~2~V"euroasm.ico"~3~N, ImageBase=, ListGlobals=~2~VON~3~N, ListLiterals=~2~VON~3~N, ListMap=~2~VON~3~N, MajorImageVersion=~2~V1~3~N, MaxErrors=~2~V128~3~N, \
      MajorLinkerVersion=~2~V 1~3~N, MajorOSVersion=~2~V 4~3~N, MajorSubsystemVersion=~2~V 4~3~N, MaxExpansions=~2~V64K~3~N, MaxPasses=~2~V32~3~N, MinorImageVersion=~2~V0~3~N, \
      MinorLinkerVersion=~2~V 0~3~N, MinorOSVersion=~2~V 0~3~N, MinorSubsystemVersion=~2~V 0~3~N, Model=~2~VTINY|SMALL|MEDIUM|COMPACT|LARGE|HUGE|FLAT~3~N,
      OutFile=~2~V"%^Program.~Sext~V"~3~N, SectionAlign=, SizeOfHeapCommit=~2~V1M~3~N, SizeOfHeapReserve=~2~V4M~3~N, SizeOfStackCommit=~2~V4K~3~N, \
      SizeOfStackReserve=~2~V1M~3~N, StubFile=~2~V"coffstub.exe"~3~N, Subsystem=~2~VCON|GUI|NATIVE|OS2|POSIX~3~N, Width=~2~V16|32|64~3~N, Win32VersionValue=~2~V0

~3~PSEGMENT~3~N Align=~2~V B | W | D | Q | O | Y | Z~3~N, Combine=~2~V PUBLIC | PRIVATE | COMMON | STACK~3~N, Width=~2~V 16 | 32 | 64~3~N, \
        Purpose=~2~V EXPORT |IMPORT |RESOURCE |EXCEPTION |SECURITY |BASERELOC |DEBUG |COPYRIGHT |GLOBALPTR |TLS |LOAD_CONFIG |BOUND_IMPORT |IAT |
        DELAY_IMPORT |CLR |RESERVED |CODE |DATA |RODATA |BSS |STACK |LITERAL |DRECTVE |PHDR |SYMBOLS |DYNAMIC |STRINGS |RELOC |GOT |PLT |HASH |INTERP
~3~P
PROC~3~N  Align=~2~V B | W | D | Q~3~N, NestingCheck=~2~V ON~3~N, Dist=~2~V N | F~3~P  ;  ENDPROC
PROC1~3~N Align=~2~V B | W | D | Q~3~N, NestingCheck=~2~V ON~3~N, Dist=~2~V N | F~3~P  ;  ENDPROC1
STRUC~3~N Align=~2~V B | W | D | Q | O | Y | Z~3~P  ;  ENDSTRUC
ALIGN ; D ; DB ; DU ; DW ; DD ; DQ ; DT ; DO ; DY ; DZ ; DI ; DS~3~N Align=~2~V B | W | D | Q | O | Y | Z~3~P
EQU  ;  =  ;  HEAD  ;  ENDHEAD  ;  GLOBAL ; EXTERN ; PUBLIC ; IMPORT~N Lib=~2~V "library.dll"~3~P ; EXPORT~N Fwd=~2~V Symbol~3~N, Lib=~2~V "library.dll"~3~P
INCLUDE ; INCLUDE1 ; INCLUDEHEAD ; INCLUDEHEAD1 ; INCLUDEBIN ; LINK ; GROUP ; %ERROR  ;  %COMMENT  ;  %ENDCOMMENT ;
%MACRO ; %EXITMACRO ; %DROPMACRO ; %SHIFT ; %ENDMACRO ; %SET ; %SETX ; %SET2 ; %SETA ; %SETB ; %SETC; %SETE ; %SETL ; %SETS
%IF ; %ELSE ; %ENDIF ; %FOR~N Step=~2~V 0~3~P ; %EXITFOR ; %ENDFOR ; %REPEAT ; %EXITREPEAT ; %UNTIL ; %WHILE ; %EXITWHILE ; %ENDWHILE
%DISPLAY~N Al~2l=~V *~3~N, Fil~2es~3, Ch~2unks~3, Co~2ntext~3, Se~2ctions~3, Se~2gments~3, G~2roups~3, St~2ructures~3, Rel~2ocations~3,
      Sym~2bols=~3~V *~N, Unf~2ixedSymbols=~V *~3~N, Fix~2edSymbols=~V *~3~N, Unr~2eferencedSymbols=~3~V *~N, Ref~2erencedSymbols=~V *~N~3, L~2iteralSymbols~3,
      M~2acros=~V *~3~N, V~2ariables=~V *~3~N, Au~2tomaticVariables=~V *~3~N, Fo~2rmalVariables=~V *~3~N, Us~2erVariables=~V *~3~N, Sys~2temVariables=~V *~3~N

~5~L                     Machine instruction suffixes
B | W | D | Q~3~I ADC ; ADD ; AND ; CMP ; CMPS ; CRC32 ; DEC ; DIV ; IDIV ; IMUL ; INC ; LODS ; MOV ; MOVS ; MUL ; NEG ; NOT
                   OR ; RCL ; RCR ; ROL ; ROR ; SAL ; SAL2 ; SAR ; SBB ; SCAS ; SHL ; SHR ; STOS ; SUB ; TEST ; TEST2 ; XOR~5~L
W | D ~3~I          PUSHA ; POPA~5~L
B | W | D~3~I      INS ; MOVSX ; MOVZX ; OUTS~5~L
B~3~I                XLAT~5~L
N | F ~3~I          CALL, RET~5~L
S | N | F ~3~I     JMP
~5~L                    Machine instruction modifiers
~3~NALIGN=~2~V B | W | D | Q~3~N, CODE=~2~V S | L~3~N, DATA=~2~V B | W | D | Q | O | T | Y | Z,~3~N, IMM=~2~V B | W | D | Q~3~N, DISP=~2~V B | W | D | Q~3~N, DIST=~2~V N | F | S~3~N,
SCALE=~2~V S | V~3~N, ADDR=~2~V R | A~3~N, PREFIX=~2~V XOP | VEX | VEX2 | VEX3 | MVEX | EVEX~3~N, MASK=~2~V K0 | K1| K2 | K3 | K4 | K5 | K6 | K7~3~N, ZEROING=~2~V OFF~3~N,
BCST=~2~V OFF~3~N, EH=~2~V OFF~3~N, SAE=~2~V OFF~3~N, ROUND=~2~V N | U | D | Z~3~N, OPER=~2~V 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7
';

$Operations='
~5~L FP constants ~3~V #ZERO, #INF, #PINF, #NAN, #PNAN, #QNAN, #SNAN
~5~L Attributes ~3~T SIZE#, TYPE#, REGTYPE#, SCOPE#, SECTION#, SEGMENT#, GROUP#, PARA#, FILESIZE#, FILETIME#

~5~L Operations ~3~P  Priority~3~I  Name
    ~2~VObject~3~I.~2~VMember    ~3~P16~2~I Membership
   ~2~TATTRIBUTE#~2~V Object  ~3~P15~2~I Attribute
~2~V"string"~3~I == ~2~V"string" ~3~P14~2~I Case-ins.Equal
~2~V"string"~3~I=== ~2~V"string" ~3~P14~2~I Case-sens.Equal
~2~V"string"~3~I!== ~2~V"string" ~3~P14~2~I Case-ins.Nonequal
~2~V"string"~3~I!===~2~V"string" ~3~P14~2~I Case-sens.Nonequal
        ~3~I+ ~2~Vnumber      ~3~P13~2~I Plus
        ~3~I- ~2~Vnumber      ~3~P13~2~I Minus
~2~Vnumber~3~I <<  ~2~Vnumber    ~3~P12~2~I Shift Logical Left
~2~Vnumber~3~I #<< ~2~Vnumber    ~3~P12~2~I Shift Arith. Left
~2~Vnumber~3~I >>  ~2~Vnumber    ~3~P12~2~I Shift Logical Right
~2~Vnumber~3~I #>> ~2~Vnumber    ~3~P12~2~I Shift Arith. Right
~2~Vnumber~3~I  /  ~2~Vnumber    ~3~P11~2~I Unsigned Division
~2~Vnumber~3~I #/  ~2~Vnumber    ~3~P11~2~I Signed Division
~2~Vnumber~3~I  \  ~2~Vnumber    ~3~P11~2~I Unsigned Modulo
~2~Vnumber~3~I #\  ~2~Vnumber    ~3~P11~2~I Signed Modulo
~2~Vnumber~3~I  *  ~2~Vnumber    ~3~P11~2~I Unsigned Multiplication
~2~Vnumber~3~I #*  ~2~Vnumber    ~3~P11~2~I Signed Multiplication
~2~Vnumber~3~I  *  ~2~Vregister  ~3~P10~2~I Scaling
~2~Vnumber~3~I  +  ~2~Vnumber    ~3~P 9~2~I Addition
~2~Vnumber~3~I  -  ~2~Vnumber    ~3~P 9~2~I Subtraction
~2~Vnumber~3~I  +  ~2~Vregister  ~3~P 9~2~I Indexing
       ~3~I ~~ ~2~V number    ~3~P 8~2~I Bitwise NOT
~2~Vnumber~3~I  &  ~2~Vnumber    ~3~P 7~2~I Bitwise AND
~2~Vnumber~3~I  |  ~2~Vnumber    ~3~P 6~2~I Bitwise OR
~2~Vnumber~3~I  ^  ~2~Vnumber    ~3~P 6~2~I Bitwise XOR
~2~Vnumber~3~I  >  ~2~Vnumber    ~3~P 5~2~I Above
~2~Vnumber~3~I #>  ~2~Vnumber    ~3~P 5~2~I Greater
~2~Vnumber~3~I  <  ~2~Vnumber    ~3~P 5~2~I Below
~2~Vnumber~3~I #<  ~2~Vnumber    ~3~P 5~2~I Lower
~2~Vnumber~3~I >=  ~2~Vnumber    ~3~P 5~2~I Above or Equal
~2~Vnumber~3~I #>= ~2~Vnumber    ~3~P 5~2~I Greater or Equal
~2~Vnumber~3~I <=  ~2~Vnumber    ~3~P 5~2~I Below or Equal
~2~Vnumber~3~I #<= ~2~Vnumber    ~3~P 5~2~I Lower or Equal
~2~Vnumber~3~I  =  ~2~Vnumber    ~3~P 5~2~I Numeric Equal
~2~Vnumber~3~I !=  ~2~Vnumber    ~3~P 5~2~I Numeric Nonequal
        ~3~I!  ~2~Vnumber    ~3~P 4~2~I Logical NOT
~2~Vnumber~3~I &&  ~2~Vnumber    ~3~P 3~2~I Logical AND
~2~Vnumber~3~I ||  ~2~Vnumber    ~3~P 2~2~I Logical OR
~2~Vnumber~3~I ^^  ~2~Vnumber    ~3~P 2~2~I Logical XOR
~2~Vnumber~3~I  :  ~2~Vnumber    ~3~P 1~2~I Segment separation
~2~Vnumber~3~I ..  ~2~Vnumber    ~3~P 0~2~I Range
~2~Vnumber~3~I  *  ~2~Vdatatype  ~3~P 0~2~I Data duplication
';

$SystemVariables='
      ~5~LEuroAssembler system variables
~3~S%^Date, %^EuroasmOs, %^Errorlevel, %^Pass, %^Proc, %^Program, %^Section,
%^Segment, %^SourceFile, %^SourceName, %^SourceExt, %^SourceLine,  %^Time,
%^Version

       ~5~LEUROASM system variables
~3~S%^ABM, %^AES, %^AMD, %^AutoAlign, %^AutoSegment, %^CET, %^CodePage, %^CPU,
%^CYRIX, %^D3NOW, %^Debug, %^DisplayEnc, %^DisplayStm, %^Dump, %^DumpAll,
%^DumpWidth, %^EVEX, %^FMA, %^FPU, %^IncludePath, %Interpreter, %^LinkPath,
%^List, %^ListFile, %^ListInclude, %^ListMacro, %^ListRepeat, %^ListVar,
%^LWP, %^MaxInclusions, %^MaxLinks, %^MMX, %^MPX, %^MVEX, %^NoWarn, %^PRIV,
%^Profile, %^PROT, %^RunPath, %^SIMD, %^SHA, &^SIMD, %^SPEC, %^SVM, %^TBM,
%^TimeStamp, %^TSX, %^UNDOC, %^Unicode, %^VIA, %^VMX, %^Warn, %^XOP

       ~5~LPROGRAM system variables
~3~S%^DllCharacteristics, %^Entry, %^FileAlign, %^Format, %^IconFile,
%^ImageBase, %^ListGlobals, %^ListLiterals, %^ListMap, %^MajorImageVersion,
%^MajorLinkerVersion, %^MajorOSVersion, %^MajorSubsystemVersion,
%^MaxExpansions, %^MaxPasses, %^MinorImageVersion, %^MinorLinkerVersion,
%^MinorOSVersion, %^MinorSubsystemVersion, %^Model, %^OutFile, %^SectionAlign,
%^SizeOfHeapCommit,%^SizeOfHeapReserve,%^SizeOfStackCommit,%^SizeOfStackReserve,
%^StubFile, %^Subsystem, %^TimeStamp, %^Width, %^Win32VersionValue

       ~5~LAutomatic suboperation variable
~3~S %&       ~2~L Number of characters | list items | physical lines.
             Valid only in suboperation brackets [1..%&] or {1..%&}

        ~5~LAutomatic macro variables
~3~S %1       ~2~L Ordinal operand Nr.1.
~3~S %!1      ~2~L Inverted condition code of operand Nr.1.
~3~S %Formal  ~2~L Ordinal operand with formal name.
~3~S %!Formal ~2~L Inverted condition code of operand with formal name.
~3~S %*       ~2~L List of all ordinal operands in macro invokation.
~3~S %#       ~2~L Number of ordinal operands in macro invokation.
~3~S %=*      ~2~L List of all keyword operands in macro invokation.
~3~S %=#      ~2~L Number of keyword operands in macro invokation.
~3~S %:       ~2~L Label of macro invokation.
~3~S %.       ~2~L Expansion number.
';

$Reserved='
        ~5~LReserved symbol names
~3~V$, CS, DS, ES, FS, GS, SS, ATOGGLE, LOCK, OFTEN, OTOGGLE, REP, REPE, REPNE,
REPNZ, REPZ, SEGCS, SEGDS, SEGES, SEGFS, SEGGS, SEGSS, SELDOM, XACQUIRE, XRELEASE
';

ImageText($Img,48,50,$Instructions,$Palete);
ImageText($Img,48,732,$Operations,$Palete);
ImageText($Img,380,772,$Reserved,$Palete);
ImageText($Img,380,840,$SystemVariables,$Palete);
imagepng($Img,$FileName);
imagedestroy($Img);
return(true);
} // endFn GenerateCrib
?>
