<?php /* €ASM test manager eatests/testman.php */
header('Content-Type: text/html; charset=utf-8');
$Keys=array('T','D','S','P','I','J','K','A','L','M','E','B'); // Order of test divisions.
$Extensions=array('','bin','com','exe','dll','o','obj','lib','sec','so','x'); // Supported output file extensions.
$Actions=array('Load','Preview','Edit','Delete','Save','SaveAs','Run','RunAll','Accept');
$action='Preview'; foreach ($Actions as $button) if (isset($_REQUEST[$button])) $action=$button;
$test=GetTestId('test'); // Test name, e.g. "t1234".
if (!$newtest=GetTestId('newtest')) $newtest=GetTestId('newtest2'); // When SaveAs was pressed.
$Loaded=LoadTestFile($test);
$TEST=Parse($Loaded,$Keys);
foreach ($Keys as $Key)
{if (isset($_REQUEST[$Key]))
 {$TEST[$Key]=false;
  if (trim($_REQUEST[$Key]))
  {$Lines=explode("\n",$_REQUEST[$Key]); foreach ($Lines as $line) $TEST[$Key][]=rtrim($line);
}}} $Status="";
if (!$test && $action<>'RunAll')
{echo Head($test);
 echo "<p>Test manager can create, edit, rename, view and execute short
<a href='../eatests/'>test programs</a> used to check whether EuroAssembler works as expected.</p>\r\n";
 echo Tail();
 exit;
} // endif !$test
$SLASH=PHP_OS=="Linux"?'/':'\\';
$TestedExe=EUROASM_HOME().$SLASH."easource".$SLASH."euroasm.exe";
if (!file_exists($TestedExe))
{$Status="<del>The tested executable <q>$TestedExe</q> was not found.</del>\r\n";
      echo Head($test);
      echo StatusLine($Status);
      echo Buttons($test);
      echo $Loaded;
      if ($Loaded) echo Buttons($test,2);
      echo Tail();
      exit();
}
@unlink(EUROASM_HOME().$SLASH."easource".$SLASH."euroasm.ini");
@unlink(EUROASM_HOME().$SLASH."eatests".$SLASH."euroasm.ini");
switch ($action) {
case 'SaveAs':
     if (!$newtest)
     {$Status="<del>Specify the new test identification.</del>\r\n";
      echo Head($test);
      echo StatusLine($Status);
      echo Buttons($test);
      echo $Loaded;
      if ($Loaded) echo Buttons($test,2);
      echo Tail();
      exit();
     } else
      $newLoaded=str_replace($test,$newtest,$Loaded);
      $test=$newtest;
      $TEST=Parse($newLoaded,$Keys);
case 'Save':
      if (SaveTestFile($test,$TEST)) $Status.="Test $test was saved.\r\n";
      else $Status.="<del>Error writing file <q>".GetFileName($test)."</q>.</del>\r\n";
      $Loaded=LoadTestFile($test);
case 'Load':
      if (!$Loaded)
      {$Status.="<del>Test <q>$test.htm</q> was not found.</del><br/>You can create a new test now.\r\n";
      $TEST=Parse($Loaded,$Keys);
      echo Head($test);
      echo StatusLine($Status);
      echo Buttons($test);
      echo Form($test,$TEST,$Extensions);
      echo Buttons($test,2);
      echo Tail();
      exit();}
case 'Preview':
      echo Head($test);
      echo StatusLine($Status);
      echo Buttons($test);
      echo $Loaded;
      if ($Loaded) echo Buttons($test,2);
      echo Tail();
      exit();
case 'Edit':
      $TEST=Parse($Loaded,$Keys);
      echo Head($test);
      echo StatusLine($Status);
      echo Buttons($test);
      echo Form($test,$TEST,$Extensions);
      echo Buttons($test,2);
      echo Tail();
      exit();
case 'Delete':
      $FileName=GetFileName($test);
      @unlink("$FileName.bak");
      if (rename("$FileName","$FileName.bak"))
         $Status.="Test $test was deleted (renamed to <q>$test.htm.bak</q>).\r\n";
      else $Status.="<del>Test $test could not be deleted.</del>\r\n";
      echo Head($test);
      echo StatusLine($Status);
      echo Tail();
      exit();
case 'Accept':
      $Status.=Accept($test,$TEST);
      $Loaded=LoadTestFile($test);
      $TEST=Parse($Loaded,$Keys);
case 'Run':
      $Result=RunTest($test,$TEST);
      if ($Result['Passed']) $Status.=$Result['Status']."<br/>Test $test passed.\r\n";
      else $Status.=$Result['Status']."<br/><del>Test $test failed.</del>\r\n";
      echo Head($test);
      echo "<b>$test ".$TEST['T'][0]."</b><br/>\r\n";
      echo $TEST['D'][0]."\r\n";
      echo StatusLine($Status);
      echo Buttons($test);
      if ($Result['Passed']) echo $Loaded; else echo $Result['Diff'];
      echo Buttons($test,2);
      echo Tail();
      exit();
case 'RunAll':
      $StartTime=time();
      echo Head(false);
      $Tests=TestDir();
      $PassedCnt=$FailedCnt=0;
      echo "<dl class='STATUS'><dd>Running all EuroAssembler tests\r\n"
      .$Tests[0]."..".$Tests[count($Tests)-1]."</dd></dl>\r\n<br/><br/>\r\n";
      foreach ($Tests as $test)
      {$Loaded=LoadTestFile($test);$TEST=Parse($Loaded,$Keys);
       $TestName="<a class='EXT' href='$test.htm'>$test</a> ".@$TEST['T'][0];
       echo "<div class='RESULT'>$TestName ... ";@ob_flush();flush();
       $Result=RunTest($test,$TEST);
       if ($Result['Passed']) {$PassedCnt++; echo "passed.</div>"; }
       else
        {$FailedCnt++; echo "<del>failed.</del></div>";
         echo "<del>$TestName ... failed.</del><br/>\r\n";
        } @ob_flush();flush();
        echo "<div class='RESULT'></div>";
       } // endforeach $test
       $duration=time()-$StartTime;
       if ($FailedCnt)
        {$Status="<b>$PassedCnt</b> tests passed, <del><b>$FailedCnt</b> failed in $duration seconds.</del>\r\n";}
       else {$Status="<b>All $PassedCnt tests passed in $duration seconds.</b>\r\n";}
       echo "<div class='RESULT'>&emsp;</div>\r\n";
       echo StatusLine($Status);
       echo Tail();
       exit();
} // endSwitch $action
exit();

function Head($test) // Return test file header.
{return "<!doctype html><html><head>
<meta http-equiv='Content-Type' content='text/html; charset=utf-8'/>
<meta name='viewport' content='width=device-width, initial-scale=1.0, maximum-scale=2.0, user-scalable=yes'>
<meta name='description' content='EuroAssembler test manager'/>
<link rel='stylesheet' href='../euroasm.css' type='text/css'/>
<link rel='shortcut icon' href='../favicon.ico'/>
<title>$test test manager</title>
</head>
<body class='EATESTS' id='top' onload='document.getElementById(\"Wait\").style.display=\"none\";'>
<div class='HEADMENU'><table>
<tr><td rowspan='2' title='&euro;ASM - assembler and linker'><img src='../favicon.ico' alt='EuroAssembler' />
<td><a href='../index.htm' title='Alphabetical index of all &euro;ASM elements, directives and instructions'>Index</a></td>
<td><a href='../eadoc/' class='EADOC' title='Documentation of EuroAssembler'>Manual</a></td>
<td><a href='https://euroassembler.eu/download/' title='History &amp; download of the latest and previous versions'>Download</a></td>
<td><a href='../easource/' class='EASOURCE' title='Source files of EuroAssembler itself'>Source</a></td>
<td><a href='../maclib/' class='MACLIB' title='Macro libraries shipped with &euro;ASM'>Macros</a></td>
<td rowspan='2' title='Find the searched token in any text file on this site'>
<form method='post' action='../search.php' enctype='multipart/form-data' accept-charset='utf-8'>
<input type='text' id='q' placeholder='Searched word(s)' name='q' value=''/>
<br/><label title='Check the box to find the expression even if it is surrounded by other letters | digits.'>
<input type='checkbox' id='EW' name='EW'/><small>Embedded word</small></label>
<br/><label title='Check the box for case-insensitive search.'>
<input type='checkbox' id='CI' name='CI'/><small>Case ins.</small></label>
<input type='submit' title='Search for the specified word|expression in all site files.' id='find' name='find' value='Search'/>
</form></td></tr><tr>
<td><a href='../sitemap.htm' title='List of directories and files on this site'>Sitemap</a></td>
<td><a href='../eadoc/links.htm' class='EADOC' title='References and external links to authoritative resources used in EuroAssembler developement'>Links</a></td>
<td><a href='https://euroassembler.eu/forum/' title='Discussion forum concerning EuroAssembler'>Forum</a></td>
<td><a href='../eatests/' class='EATESTS' title='Program snippets for testing the function of &euro;ASM'>Tests</a></td>
<td><a href='../objlib/' class='OBJLIB' title='Skeletons and sample objects and projects shipped with &euro;ASM'>Projects</a></td>
</tr></table></div>
<!--/HEADMENU-->
<img id='Wait' src='../objlib/wait.gif' alt='Please wait...' title='Please wait...'/>
<h1>&euro;ASM test manager</h1>
<form action='testman.php' method='post'>Select the test number:
<input type='text' name='test' maxlength='5' size='3' value='$test' placeholder=' t1234' title='Write four digits, optionally prefixed with letter t'/>
<input type='submit' name='Load' value='Load'/> &emsp; &emsp;
<input type='submit' name='RunAll' value='Run all tests'/>\r\n<br class='CLEAR'/>\r\n";
} // EndFn Head

function Tail() // Return test file tail.
{global $test,$newtest,$TEST;
return "</form>\r\n<!--TAILMENU-->\r\n<br class='CLEAR'/>"
."<a id='bottom' href='#top'>&#x25B2;Back to the top&#x25B2;</a>\r\n</body></html>";
} // endFn Tail

function Buttons($test,$nr='')
{$LF=$nr?"":"\r\n";
return "$LF<input type='submit' name='Preview' value='Preview $test'/> &nbsp;
<input type='submit' name='Edit' value='Edit $test'/> &nbsp;
<input type='submit' name='Save' value='Save $test'/> &nbsp;
<input type='submit' name='SaveAs' value='Save as'/>
<input type='text' name='newtest$nr' maxlength='5' size='3' value='' placeholder='t1234'
title='Write four digits, optionally prefixed with letter t'/> &nbsp;
<input type='submit' name='Delete' value='Delete $test'/> &nbsp;
<input type='submit' name='Run' value='Run $test'/>\r\n<br class='CLEAR'/>\r\n";
} // endFn Buttons

function Form($test,$TEST,$Extensions) // Return test editor HTML form.
{foreach ($TEST as $division=>$value)
{switch ($division)
 {case 'T': $Trows=1; break;
  case 'C': $Crows=1; break;
  case 'L': $Lrows=max(9,@count($TEST[$division]))+1; break;
  case 'M': $Mrows=max(7,@count($TEST[$division]))+1; break;
  default: ${$division."rows"}=@max(2,@count($TEST[$division]))+1;
 } ${$division."safe"}=@htmlspecialchars(implode("\r\n",$TEST[$division]),ENT_QUOTES);
} $Eselect="<select name='E' title='Set to empty if no object file is generated'>\r\n";
foreach ($Extensions as $e)
{$Eselect.="<option value='$e'";if ($e==@$TEST['E'][0]) $Eselect.=" selected";
if ($e) $Eselect.=">$e</option>\r\n"; else $Eselect.=">&nbsp;</option>\r\n";
}$Eselect.="</select>\r\n";
return "<dl>
<dt>Title of test <a class='EXT' href='$test.htm'>$test</a></dt>
<dd><textarea rows='$Trows' name='T' placeholder='Subject of test...'>$Tsafe</textarea></dd>
<dt>Description</dt>
<dd><textarea rows='$Drows' name='D' placeholder='More detailed description of tested instruction or function. HTML tags are allowed.'>$Dsafe</textarea></dd>
<dt>See also</dt>
<dd title='Identifiers of similar tests, each on a separate line.'>
<textarea rows='$Srows' name='S' placeholder='t7777\r\nt8888'>$Ssafe</textarea></dd>
<dt>Tested procedures</dt>
<dd title='Names of tested &euro;ASM source procedures, each on a separate line.'>
<textarea name='P' rows='$Prows' placeholder='IiMOVSD\r\nIiAssemble'>$Psafe</textarea></dd>
<dt>Included file 1 <q>$test.i.asm</q></dt>
<dd><textarea rows='$Irows' name='I' placeholder='Contents of the file. Leave empty if not needed.'>$Isafe</textarea></dd>
<dt>Included file 2 <q>$test.j.asm</q></dt>
<dd><textarea rows='$Jrows' name='J' placeholder='Contents of the file. Leave empty if not needed.'>$Jsafe</textarea></dd>
<dt>Included file 3 <q>$test.k.asm</q></dt>
<dd><textarea rows='$Krows' name='K' placeholder='Contents of the file. Leave empty if not needed.'>$Ksafe</textarea></dd>
<dt>Source file <q>$test.asm</q></dt>
<dd><textarea rows='$Arows' name='A' placeholder='Source code of the test. Leave empty if the listing is used as source.'>$Asafe</textarea></dd>
<dt>Listing (&amp; source)</dt>
<dd title='Expected listing contents. May be also used as the source code.'>
<textarea name='L' rows='$Lrows' placeholder='| | EUROASM LIST=ON,DUMP=ON,DUMPWIDTH=24
| |$test PROGRAM FORMAT=BIN,LISTMAP=OFF,LISTGLOBALS=OFF
| |; Tested instructions
| | ENDPROGRAM $test'>$Lsafe</textarea></dd>
<dt>Messages output</dt>
<dd title='Expected messages.'><textarea name='M' rows='$Mrows' placeholder='I0990 EuroAssembler terminated with errorlevel 0.\r\n
I0990 EuroAssembler terminated with errorlevel 0.'>$Msafe</textarea></dd>
<dt>Object file extension</dt>
<dd>$Eselect</dd>
<dt>Contents of output file <q>$test.$Esafe</q></dt>
<dd title='Expected contents of output file.'>
<textarea name='B' rows='$Brows' placeholder='0000: 00 01 02 03 04 ...'>$Bsafe</textarea></dd>
</dl><br class='CLEAR'/>\r\n";
} // endFn Form

function EUROASM_HOME() // Returns string e.g. "C:\\Projects\\euroasm"
{$SLASH=PHP_OS=="Linux"?'/':'\\'; // Function assumes that it's called from ..\eatests\testman.php
return strtr(substr($_SERVER['SCRIPT_FILENAME'],0,-20),"/",$SLASH);
} // endFn EUROASM_HOME

function GetFileName($test)
{$SLASH=PHP_OS=="Linux"?'/':'\\';
return EUROASM_HOME().$SLASH."eatests".$SLASH.$test.".htm";
} // endFn GetFileName

function GetTestId($ReqName) // Returns submitted test, e.g. 't1234' or ''.
{$test=@$_REQUEST[$ReqName]; // Accepts only four decimal digits, optionally prefixed with 't'.
$testNr='';
for ($i=0;$i<strlen($test);$i++) if (($test{$i}<='9') && ($test{$i}>='0')) $testNr.=$test{$i};
if ($testNr<=9999 && $testNr>0) return 't'.substr("000$testNr",-4);
else return '';
} // endFn GetTestId

function LoadTestFile($test) // Return the contents of test file between /HEADMENU and TAILMENU markers.
{if (!$FileContents=@file_get_contents(GetFileName($test))) return false;
 $HeadmenuPos=strpos($FileContents,"<!--/HEADMENU-->")+16;
 $TailmenuPos=strpos($FileContents,"<!--TAILMENU-->");
 return substr($FileContents,$HeadmenuPos,$TailmenuPos-$HeadmenuPos);
} // endFn LoadTestFile

function StatusLine($Status) // Return division with status line.
{if ($Status) return "<dl class='STATUS'><dd>$Status</dd></dl>"; else return "";
} // endFn StatusLine

function Parse($Loaded,$Keys) // Convert HTML test source $Loaded and return array $TEST.
{$TEST=array();foreach ($Keys as $Key) $TEST[$Key]=false;
 $LoadedLines=explode("\n",$Loaded);
 foreach ($LoadedLines as $line)
 {$mark=substr($line,0,8);
  foreach ($Keys as $Key)
      if ($mark=="<!--$Key-->") $TEST[$Key][]=html_entity_decode(rtrim(substr($line,8)),0,"UTF-8");
  $Char1=substr(ltrim($line),0,1);
  if ($Char1 != '' && $Char1 != '<') $TEST['L'][]=trim($line); // Listing lines do not have a marker.
 } // endforeach $line
 if ($TEST['P']) $TEST['P']=UniqExplode(@implode(',',$TEST['P']));
 if ($TEST['S']) $TEST['S']=UniqExplode(@implode(',',$TEST['S']));
 if ($TEST['B']) foreach ($TEST['B'] as $lineNr=>$dumpline) $TEST['B'][$lineNr]=rtrim(substr($dumpline,0,53));
return $TEST; } // endFn Parse

function UniqExplode($InpString)
// Expand $InpString by commas and whitespaces, return array of uniq nonempty substrings.
{$A=array(); $length=strlen($InpString);
$i=0; while ($i<$length)
{$OutString=""; while ($i<$length&&$InpString[$i]<>',' && ord($InpString[$i])>32) $OutString.=$InpString[$i++];
 if (trim($OutString)) $A[]=$OutString;$i++;
} return array_unique($A); } // endFn UniqExplode

function SaveTestFile($test,$TEST) // Save test from array $TEST to a disk file. Return FALSE on failure.
{$TestFile=GetFileName($test); $Version=date("Ymd");
$TS="<!doctype html><html lang='en'><head>\r\n"
."<meta http-equiv='Content-Type' content='text/html; charset=utf-8'/>\r\n"
."<meta name='viewport' content='width=device-width, initial-scale=1.0, maximum-scale=2.0, user-scalable=yes'/>\r\n"
."<meta name='robots' content='ALL,FOLLOW'/>\r\n"
."<meta name='description' content='$test.htm test file'/>\r\n"
."<meta name='version' content='$Version'/>\r\n"
."<meta name='author' content='Pavel vitsoft Šrubař'/>\r\n"
."<link rel='stylesheet' href='../euroasm.css' type='text/css'/>\r\n"
."<link rel='shortcut icon' href='../favicon.ico'/>\r\n"
."<title>$test.htm test file</title>\r\n"
."</head>\r\n"
."<body class='EATESTS' id='top'><div class='HEADMENU'><table>\r\n"
."<tr><td rowspan='2' title='&euro;ASM - assembler and linker'><img src='../favicon.ico' alt='EuroAssembler' />\r\n"
."<td><a href='../index.htm' title='Alphabetical index of all &euro;ASM elements, directives and instructions'>Index</a></td>\r\n"
."<td><a href='../eadoc/' class='EADOC' title='Documentation of EuroAssembler'>Manual</a></td>\r\n"
."<td><a href='https://euroassembler.eu/download/' title='History &amp; download of the latest and previous versions'>Download</a></td>\r\n"
."<td><a href='../easource/' class='EASOURCE' title='Source files of EuroAssembler itself'>Source</a></td>\r\n"
."<td><a href='../maclib/' class='MACLIB' title='Macro libraries shipped with &euro;ASM'>Macros</a></td>\r\n"
."<td rowspan='2' title='Find the searched token in any text file on this site'>\r\n"
."<form method='post' action='../search.php' enctype='multipart/form-data' accept-charset='utf-8'>\r\n"
."<input type='text' id='q' placeholder='Searched word(s)' name='q' value=''/>\r\n"
."<br/><label title='Check the box to find the expression even if it is surrounded by other letters | digits.'>\r\n"
."<input type='checkbox' name='EW'/><small>Embedded word</small></label>\r\n"
."<br/><label title='Check the box for case-insensitive search.'>\r\n"
."<input type='checkbox' name='CI'/><small>Case ins.</small></label>\r\n"
."<input type='submit' title='Search for the specified word|expression in all site files.' name='find' value='Search'/>\r\n"
."</form></td></tr><tr>\r\n"
."<td><a href='../sitemap.htm' title='List of directories and files on this site'>Sitemap</a></td>\r\n"
."<td><a href='../eadoc/links.htm' class='EADOC' title='References and external links to resources used in EuroAssembler developement'>Links</a></td>\r\n"
."<td><a href='https://euroassembler.eu/forum/' title='Discussion forum concerning EuroAssembler'>Forum</a></td>\r\n"
."<td><a href='../eatests/' class='EATESTS' title='Program snippets for testing the function of &euro;ASM'>Tests</a></td>\r\n"
."<td><a href='../objlib/' class='OBJLIB' title='Skeletons and sample objects and projects shipped with &euro;ASM'>Projects</a></td>\r\n"
."</tr></table></div>\r\n"
."<!--Contents above the marker {!==/HEADMENU==} was generated by \"generate.php\".-->\r\n"
."<!--/HEADMENU-->\r\n"
."<h1 id='TestTitle'>Test <a class='EXT' href='$test.htm'>$test</a>:\r\n"
."<!--T-->".rtrim($TEST['T'][0])."\r\n"
."</h1><button onclick='window.location=\"../eatests/manager.php?test=$test\";'>Manage $test</button>\r\n"
."<br class='CLEAR'/>\r\n";
if (is_array($TEST['D'])||is_array($TEST['S'])||is_array($TEST['P'])) $TS.="<dl>\r\n";
 if (is_array($TEST['D']))
{$TS.="<dt>Description</dt><dd>\r\n";
 foreach ($TEST['D'] as $D) $TS.="<!--D-->".rtrim($D)."\r\n";
 $TS.="</dd>\r\n";
}if (is_array($TEST['S']))
{$TS.="<dt>See also</dt><dd>\r\n";
 foreach ($TEST['S'] as $S)
  {if ($S && $S[0]=='t' && strlen($S)==5) $url="$S.htm"; else $url="index.htm#$S";
   $TS.="<a class='EXT' href='$url'>\r\n<!--S-->$S\r\n</a> &nbsp;\r\n";
  }
 $TS.="</dd>\r\n";
}if (is_array($TEST['P']))
{$TS.="<dt>Tested procedures</dt><dd>\r\n";
 $IdSearch=array('$','?','@','%'); $IdReplace=array('do','qm','at','pc');
 foreach ($TEST['P'] as $P)
  if ($P)
  {$src=@strtolower($P[0]);$i=1; while ($P[$i]>='a') $src.=$P[$i++];
   $PId=str_replace($IdSearch,$IdReplace,$P);
   if ($src=="pseudopc") $src="pseudo";
   $SLASH=(PHP_OS=="Linux")?"/":"\\";
   if (file_exists(EUROASM_HOME().$SLASH."easource".$SLASH.$src.".htm"))
      $srcurl="../easource/$src.htm";
   else {$src="ii";$srcurl="../easource/ii.htm";$P="Ii$P";}
   $TS.="<a class='EXT' href='$srcurl#$PId'>\r\n<!--P-->$P\r\n</a> &nbsp;\r\n";
  }$TS.="</dd>\r\n";
}if (is_array($TEST['D'])||is_array($TEST['S'])||is_array($TEST['P'])) $TS.="</dl>\r\n";
 if (is_array($TEST['I'])) if (trim(implode('',$TEST['I'])))
{$TS.="<dl><dt>Included file 1 <q>$test.i.asm</q></dt><dd><pre>\r\n";
 foreach ($TEST['I'] as $I) $TS.="<!--I-->".rtrim($I)."\r\n";
 $TS.="</pre></dd></dl>\r\n";
}if (is_array($TEST['J'])) if (trim(implode('',$TEST['J'])))
{$TS.="<dl><dt>Included file 2 <q>$test.j.asm</q></dt><dd><pre>\r\n";
 foreach ($TEST['J'] as $J) $TS.="<!--J-->".rtrim($J)."\r\n";
 $TS.="</pre></dd></dl>\r\n";
}if (is_array($TEST['K'])) if (trim(implode('',$TEST['K'])))
{$TS.="<dl><dt>Included file 3 <q>$test.k.asm</q></dt><dd><pre>\r\n";
 foreach ($TEST['K'] as $K) $TS.="<!--K-->".rtrim($K)."\r\n";
 $TS.="</pre></dd></dl>\r\n";
}if (is_array($TEST['A'])) if (trim(implode('',$TEST['A'])))
{$TS.="<dl><dt>Source file <q>$test.asm</q></dt><dd><pre>\r\n";
 foreach ($TEST['A'] as $A) $TS.="<!--A-->".rtrim($A)."\r\n";
 $TS.="</pre></dd></dl>\r\n";
}if (is_array($TEST['A']))  $Ltitle="Expected listing <q>$test.asm.lst</q>";
 else $Ltitle="Source &amp; expected listing <q>$test.htm.lst</q>";
 if (is_array($TEST['L']))
{$TS.="<dl><dt>$Ltitle</dt><dd><samp>\r\n";
 foreach ($TEST['L'] as $L) $TS.=rtrim($L)."\r\n";
 $TS.="</samp></dd></dl>\r\n";
}if (is_array($TEST['M']))
 {$TS.="<dl><dt>Expected messages <q>$test.out</q></dt><dd><code class='PRE'>\r\n";
 foreach ($TEST['M'] as $M) $TS.="<!--M-->".rtrim($M)."\r\n";
 $TS.="</code></dd></dl>\r\n";
}if (is_array($TEST['E']) && trim($TEST['E'][0]))
 {$TS.="<dl><dt>Expected output file <q>$test.\r\n<!--E-->".trim($TEST['E'][0])."\r\n</q></dt><dd><pre>\r\n";
 foreach ($TEST['B'] as $B) $TS.="<!--B-->".DumpCharColumn($B)."\r\n";
 $TS.="</pre></dd></dl>\r\n";
 }$TS.="<!--TAILMENU-->\r\n".
 "<!--Contents below the marker {!==TAILMENU==} was generated by \"generate.php\".-->\r\n".
 "<br class='CLEAR'/><a id='bottom' href='#top'>&#x25B2;Back to the top&#x25B2;</a>\r\n</body></html>";
return file_put_contents($TestFile,$TS);
} // endFn SaveTestFile


function UrlExists($RelativeUrl)
{if (isset($_SERVER['HTTP_ORIGIN'])) $HomeUrl=$_SERVER['HTTP_ORIGIN'];
 else {$Referer=$_SERVER['HTTP_REFERER']; // Older webserver SW doesn't set HTTP_ORIGIN.
       if (!$RefLength=strlen($Referer)) return true; // Unknown webserver SW, ignore.
       $HomeUrl=substr($Referer,0,$RefLength-strlen("/testman.php"));
      }
 $UrlHeaders=get_headers($HomeUrl.$RelativeUrl);
 return strpos($UrlHeaders[0],"200");
} // endFn UrlExists

function DumpCharColumn($dumpline) // Returns $dumpline completed with character column.
{$HexLine=trim(substr($dumpline,0,53));
while (strlen($HexLine)<55) $HexLine.=" ";
for ($c=6;$c<53;$c+=3)
{$D=$HexLine[$c];$J=$HexLine[$c+1];
 if ("$D$J"=="  ") break;
 if ("$D$J"=="00") {$HexLine.="&deg;";continue;}
 if ("$D$J"=="0A") {$HexLine.="&not;";continue;}
 if ("$D$J"=="20") {$HexLine.="&macr;";continue;}
 $ord=0;
 if ("$J">="0"&&"$J"<="9") $ord=ord("$J")-48;
 if ("$J">="A"&&"$J"<="F") $ord=ord("$J")-55;
 if ("$D">="0"&&"$D"<="9") $ord+=((ord("$D")-48)<<4);
 if ("$D">="A"&&"$D"<="F") $ord+=((ord("$D")-55)<<4);
 if ($ord<=32) $HexLine.="&middot;";
 if ($ord>=127) $HexLine.="&curren;";
 if ($ord>32&&$ord<127) $HexLine.=htmlspecialchars(chr($ord),ENT_QUOTES);
} return $HexLine;} // endFn DumpCharColumn

function Dump($ObjFileName) // Returns array of dumped lines.
{$DumpedLines=array(); if (!$Obj=@file_get_contents($ObjFileName)) return $DumpedLines;
// $middot=html_entity_decode("&middot;",0,"UTF-8"); // Control char surrogate.
// $bull=html_entity_decode("&bull;",0,"UTF-8");    // NonASCII char surrogate.
 $ObjSize=strlen($Obj);$a=0;$RowNr=0;
 while ($RowNr*16<$ObjSize)
 {$DumpedLine=substr("0000".strtoupper(dechex($RowNr*16)),-4).": "; // Address column.
  for ($ColNr=0;$ColNr<16;$ColNr++) // Hexadecimal column.
  {$ObjPos=16*$RowNr+$ColNr;$DumpedLine.=($ObjPos<$ObjSize)?
           strtoupper(bin2hex($Obj[$ObjPos]))." " : "   ";
  } $DumpedLines[]=DumpCharColumn($DumpedLine);$RowNr++;
 } return $DumpedLines;
} // endf Dump

function RunTest($test,$TEST) // Returns array $Result:
{$Result=array('Passed'=>false,'Status'=>'','Diff'=>'','ObtLst'=>false,'ObtMsg'=>false,'ObtObj'=>false);
set_time_limit(20);
$SLASH=(PHP_OS=="Linux")?"/":"\\";
$EATESTS=EUROASM_HOME().$SLASH."eatests";
if (!file_exists($EATESTS.$SLASH.$test.".htm"))
 {$Result['Status'].="<del>File <q>$test.htm</q> was not found.</del>\r\n";return $Result;}
// Create temporary source files from the $TEST definition.
if (is_array($TEST['A'])) {$A="";foreach ($TEST['A'] as $line) $A.=rtrim($line)."\r\n"; file_put_contents($EATESTS.$SLASH.$test.  ".asm",$A);}
if (is_array($TEST['I'])) {$I="";foreach ($TEST['I'] as $line) $I.=rtrim($line)."\r\n"; file_put_contents($EATESTS.$SLASH.$test.".i.asm",$I);}
if (is_array($TEST['J'])) {$J="";foreach ($TEST['J'] as $line) $J.=rtrim($line)."\r\n"; file_put_contents($EATESTS.$SLASH.$test.".j.asm",$J);}
if (is_array($TEST['K'])) {$K="";foreach ($TEST['K'] as $line) $K.=rtrim($line)."\r\n"; file_put_contents($EATESTS.$SLASH.$test.".k.asm",$K);}
$ListFileName=$EATESTS.$SLASH.$test.".htm.lst";
if (is_array($TEST['A'])) $ListFileName=$EATESTS.$SLASH.$test.".asm.lst";
@unlink($ListFileName); // Erase file created in previous run, if exists.
$Ext=@$TEST['E'][0]; $ObjFile=$EATESTS.$SLASH.$test.".$Ext"; @unlink($ObjFile);
$ObtMsg=array(); // Array to capture assembly standard output.
$EAEXT=(PHP_OS=="Linux")?".x":".exe";
$TestedExecutable=EUROASM_HOME().$SLASH."easource".$SLASH."euroasm".$EAEXT;
if (!file_exists($TestedExecutable))
{$Result['Status'].="<del>File <q>$TestedExecutable</q> was not found.\r\n<br/>"
 ."Build or copy the tested executable to directory &quot;easource&quot;.</del>\r\n"; return $Result;
} $TestedFile=(is_array($TEST['A']))?$test.".asm":$test.".htm";
chdir($EATESTS);
exec("$TestedExecutable $TestedFile, TIMESTAMP=0, NOWARN=0010..0170, NOWARN=0980, NOWARN=1160",$ObtMsg); // Execute the test.
$failed=false;
// Compare obtained and expected listing.
$ListLines=@explode("\r\n",file_get_contents($ListFileName));
if ($last=count($ListLines)) if (!trim($ListLines[$last-1])) unset($ListLines[$last-1]);
$ObtLst=array();foreach($ListLines as $line) $ObtLst[]=rtrim($line);
if ($ObtLst === $TEST['L'] && count($ObtLst)) $Result['Status'].="<br/>Listing passed. &nbsp;";
else
{$Result['Status'].="<del>Listing has changed.</del> &nbsp;";
 $failed=true; $ObtLstCnt=count($ObtLst); $ExpLstCnt=count($TEST['L']);
 $ObtLstFirst=$ExpLstFirst=0;
 while (isset($ObtLst[$ObtLstFirst])&&isset($TEST['L'][$ExpLstFirst])&&($ObtLst[$ObtLstFirst]===$TEST['L'][$ExpLstFirst]))
   {$ObtLstFirst++; $ExpLstFirst++;} // $ObtLstFirst is now the first nonmatching listing line.
 $ObtLstLast=$ObtLstCnt; $ExpLstLast=$ExpLstCnt;
 while (isset($ObtLst[$ObtLstLast-1])&&isset($TEST['L'][$ExpLstLast-1])&&($ObtLst[$ObtLstLast-1]===@$TEST['L'][$ExpLstLast-1]))
   {$ObtLstLast--; $ExpLstLast--;} // $ObtLstLast is now the last nonmatching line.
 $Result['Diff'].="<dl><dt>Obtained listing <q>$ListFileName</q>\r\n"
 ."<label class='RIGHT'><input type='checkbox' name='AdoptL'/> Accept as valid</label></dt><dd><samp>";
 for ($i=0;$i<$ObtLstFirst;$i++) $Result['Diff'].=$ObtLst[$i]."\r\n";
 $Result['Diff'].="<span class='DIFF'>\r\n";
 for ($i=$ObtLstFirst;$i<$ObtLstLast;$i++) if (isset($ObtLst[$i])) $Result['Diff'].=$ObtLst[$i]."\r\n";
 $Result['Diff'].="</span>";
 for ($i=$ObtLstLast;$i<$ObtLstCnt;$i++) $Result['Diff'].=$ObtLst[$i]."\r\n";
 $Result['Diff'].="</samp></dd>\r\n<dt>Expected listing</dt><dd><samp>";
 for ($i=0;$i<$ExpLstCnt;$i++) $Result['Diff'].=$TEST['L'][$i]."\r\n";
 $Result['Diff'].="</samp></dd></dl>";
 $Result['ObtLst']=$ObtLst;
} // Compare standard assembly message output.
 if ($ObtMsg === $TEST['M']) $Result['Status'].="Messages passed. &nbsp;";
 else
 {$Result['Status'].="<del>Messages output has changed.</del> &nbsp;";
  $failed=true; $ObtMsgCnt=@count($ObtMsg); $ExpMsgCnt=@count($TEST['M']);
  $ObtMsgFirst=$ExpMsgFirst=0;
  while (isset($ObtMsg[$ObtMsgFirst])&&isset($TEST['M'][$ExpMsgFirst])&&($ObtMsg[$ObtMsgFirst]===$TEST['M'][$ExpMsgFirst]))
     {$ObtMsgFirst++; $ExpMsgFirst++;} // $ObtMsgFirst is now the first nonmatching message.
  $ObtMsgLast=$ObtMsgCnt; $ExpMsgLast=$ExpMsgCnt;
  while (isset($ObtMsg[$ObtMsgLast-1])&&isset($TEST['M'][$ExpMsgLast-1])&&($ObtMsg[$ObtMsgLast-1]===$TEST['M'][$ExpMsgLast-1]))
    {$ObtMsgLast--; $ExpMsgLast--;}  // $ObtMsgLast is now the last nonmatching message.
  $Result['Diff'].="<dl><dt>Obtained output from running the test $test"
  ."<label class='RIGHT'><input type='checkbox' name='AdoptM'/> Accept as valid</label>"
  ."</dt>\r\n<dd><code class='PRE'>";
  for ($i=0;$i<$ObtMsgFirst;$i++) $Result['Diff'].=$ObtMsg[$i]."\r\n";
  $Result['Diff'].="<span class='DIFF'>";
  for ($i=$ObtMsgFirst;$i<$ObtMsgLast;$i++) if (isset($ObtMsg[$i])) $Result['Diff'].=$ObtMsg[$i]."\r\n";
  $Result['Diff'].="</span>";
  for ($i=$ObtMsgLast;$i<$ObtMsgCnt;$i++) $Result['Diff'].=$ObtMsg[$i]."\r\n";
  $Result['Diff'].="</code></dd>\r\n<dt>Expected output</dt><dd><code class='PRE'>";
  for ($i=0;$i<$ExpMsgCnt;$i++) $Result['Diff'].=$TEST['M'][$i]."\r\n";
  $Result['Diff'].="</code></dd></dl>";
  $Result['ObtMsg']=$ObtMsg;
 }// Compare the linked object|executable output file.
if (@$TEST['E'][0]) // Object extension is specified, so the object file should be compared.
{$ObtObj=Dump($ObjFile); // Obtained dump including the chars column.
 $ObtObjCnt=@count($ObtObj); $ExpObjCnt=@count($TEST['B']);
 $ObjPassed=($ObtObjCnt==$ExpObjCnt);
 if ($ObjPassed) for ($i=0;$i<$ObtObjCnt;$i++)
   if (rtrim(substr($ObtObj[$i],0,53)) !== rtrim(substr($TEST['B'][$i],0,53))){$ObjPassed=false;break;}
 if ($ObjPassed) $Result['Status'].="Object passed. &nbsp;";
 else
 {$Result['Status'].="<del>Object file has changed.</del> &nbsp;";
  $failed=true; $ObtObjFirst=$ExpObjFirst=0;
  while (isset($ObtObj[$ObtObjFirst])&&isset($TEST['B'][$ExpObjFirst])&&
         (substr($ObtObj[$ObtObjFirst],0,53)==substr($TEST['B'][$ExpObjFirst],0,53)))
     {$ObtObjFirst++; $ExpObjFirst++;} // $ObtObjFirst is now the first nonmatching dump line.
  $ObtObjLast=$ObtObjCnt; $ExpObjLast=$ExpObjCnt;
  while (isset($ObtObj[$ObtObjLast-1])&&isset($TEST['B'][$ExpObjLast-1])&&
        (trim(substr($ObtObj[$ObtObjLast-1],0,53))==trim(substr($TEST['B'][$ExpObjLast-1],0,53))))
    {$ObtObjLast--; $ExpObjLast--;}  // $ObtObjLast is now the last nonmatching dump line.
  $Result['Diff'].="<dl><dt>Obtained object <q>$test.".$TEST['E'][0]."</q>"
  ."<label class='RIGHT'><input type='checkbox' name='AdoptB'/> Accept as valid</label>"
  ."</dt>\r\n<dd><code class='PRE'>";
  for ($i=0;$i<$ObtObjFirst;$i++) if (isset($ObtObj[$i])) $Result['Diff'].=$ObtObj[$i]."\r\n";
  $Result['Diff'].="<span class='DIFF'>";
  for ($i=$ObtObjFirst;$i<$ObtObjLast;$i++) if (isset($ObtObj[$i])) $Result['Diff'].=$ObtObj[$i]."\r\n";
  $Result['Diff'].="</span>";
  for ($i=$ObtObjLast;$i<$ObtObjCnt;$i++) if (isset($ObtObj[$i])) $Result['Diff'].=$ObtObj[$i]."\r\n";
  $Result['Diff'].="</code></dd>\r\n<dt>Expected object</dt><dd><code class='PRE'>";
  for ($i=0;$i<$ExpObjCnt;$i++) $Result['Diff'].=DumpCharColumn($TEST['B'][$i])."\r\n";
  $Result['Diff'].="</code></dd></dl>";
  $Result['ObtObj']=$ObtObj;
 }
}
if ($failed)
{$Result['Diff'].="<button type='submit' name='Accept'>Accept checked output</button>\r\n<br class='CLEAR'/>";
} else
{$Result['Passed']=true;
 $Files=scandir($EATESTS);
 foreach ($Files as $file)
  {if (substr($file,0,5)<>$test) continue;
   if (strtolower($file)=="$test.htm") continue;
   unlink($EATESTS.$SLASH.$file);
  }
} return $Result;
}  // endf RunTest

function Accept($test,$TEST) // Return Status.
{$Status='';
 if (!$Accept=isset($_REQUEST['Accept'])) return $Status;
 $AcceptL=isset($_REQUEST['AdoptL']);
 $AcceptM=isset($_REQUEST['AdoptM']);
 $AcceptB=isset($_REQUEST['AdoptB']);
 if (!$AcceptL&&!$AcceptM&&!$AcceptB)
   return "<del>Investigate the obtained result(s) and either check as valid with the corresponding checkbox and button [Accept], or repair the bug in EuroAssembler.</del><br/>\r\n";
 $Result=RunTest($test,$TEST);
 if ($AcceptL) {$TEST['L']=$Result['ObtLst'];$Status.="Changed listing accepted.\r\n";}
 if ($AcceptM) {$TEST['M']=$Result['ObtMsg'];$Status.="Changed output messages accepted.\r\n";}
 if ($AcceptB) {$TEST['B']=$Result['ObtObj'];$Status.="Changed output file contents accepted.\r\n";}
 if (SaveTestFile($test,$TEST)) $Status.="<br/>File <q>$test.htm</q> was updated.\r\n";
 else $Status.="<br/><del>Error writing file <q>".GetFileName($test)."</q>.</del>\r\n";
 return $Status;
} // endFn Accept

function TestDir() // Returns array of tests.
{$SLASH=(PHP_OS=="Linux")?"/":"\\";
 $TestFiles=scandir(EUROASM_HOME().$SLASH."eatests");
 $Tests=array();
 foreach ($TestFiles as $FileName)
 {if (strlen($FileName)<>9) continue;
  if (strtolower(substr($FileName,-4))<>".htm") continue;
  if (strtolower(substr($FileName,0,1))<>"t") continue;
  $Tests[]=strtolower(substr($FileName,0,5));
 }sort($Tests); return $Tests; } // endFn TestDir
?>